package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendHotlineHeartBeat invokes the scsp.SendHotlineHeartBeat API synchronously
func (client *Client) SendHotlineHeartBeat(request *SendHotlineHeartBeatRequest) (response *SendHotlineHeartBeatResponse, err error) {
	response = CreateSendHotlineHeartBeatResponse()
	err = client.DoAction(request, response)
	return
}

// SendHotlineHeartBeatWithChan invokes the scsp.SendHotlineHeartBeat API asynchronously
func (client *Client) SendHotlineHeartBeatWithChan(request *SendHotlineHeartBeatRequest) (<-chan *SendHotlineHeartBeatResponse, <-chan error) {
	responseChan := make(chan *SendHotlineHeartBeatResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendHotlineHeartBeat(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendHotlineHeartBeatWithCallback invokes the scsp.SendHotlineHeartBeat API asynchronously
func (client *Client) SendHotlineHeartBeatWithCallback(request *SendHotlineHeartBeatRequest, callback func(response *SendHotlineHeartBeatResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendHotlineHeartBeatResponse
		var err error
		defer close(result)
		response, err = client.SendHotlineHeartBeat(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendHotlineHeartBeatRequest is the request struct for api SendHotlineHeartBeat
type SendHotlineHeartBeatRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Body"`
	InstanceId  string `position:"Body"`
	AccountName string `position:"Body"`
	Token       string `position:"Body"`
}

// SendHotlineHeartBeatResponse is the response struct for api SendHotlineHeartBeat
type SendHotlineHeartBeatResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSendHotlineHeartBeatRequest creates a request to invoke SendHotlineHeartBeat API
func CreateSendHotlineHeartBeatRequest() (request *SendHotlineHeartBeatRequest) {
	request = &SendHotlineHeartBeatRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "SendHotlineHeartBeat", "", "")
	request.Method = requests.POST
	return
}

// CreateSendHotlineHeartBeatResponse creates a response to parse from SendHotlineHeartBeat response
func CreateSendHotlineHeartBeatResponse() (response *SendHotlineHeartBeatResponse) {
	response = &SendHotlineHeartBeatResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
