package tdsr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSceneData invokes the tdsr.GetSceneData API synchronously
// api document: https://help.aliyun.com/api/tdsr/getscenedata.html
func (client *Client) GetSceneData(request *GetSceneDataRequest) (response *GetSceneDataResponse, err error) {
	response = CreateGetSceneDataResponse()
	err = client.DoAction(request, response)
	return
}

// GetSceneDataWithChan invokes the tdsr.GetSceneData API asynchronously
// api document: https://help.aliyun.com/api/tdsr/getscenedata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetSceneDataWithChan(request *GetSceneDataRequest) (<-chan *GetSceneDataResponse, <-chan error) {
	responseChan := make(chan *GetSceneDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSceneData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSceneDataWithCallback invokes the tdsr.GetSceneData API asynchronously
// api document: https://help.aliyun.com/api/tdsr/getscenedata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetSceneDataWithCallback(request *GetSceneDataRequest, callback func(response *GetSceneDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSceneDataResponse
		var err error
		defer close(result)
		response, err = client.GetSceneData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSceneDataRequest is the request struct for api GetSceneData
type GetSceneDataRequest struct {
	*requests.RpcRequest
	Token string `position:"Query" name:"Token"`
}

// GetSceneDataResponse is the response struct for api GetSceneData
type GetSceneDataResponse struct {
	*responses.BaseResponse
	RequestId    string                 `json:"RequestId" xml:"RequestId"`
	Success      bool                   `json:"Success" xml:"Success"`
	ErrMessage   string                 `json:"ErrMessage" xml:"ErrMessage"`
	Data         map[string]interface{} `json:"Data" xml:"Data"`
	ObjectString string                 `json:"ObjectString" xml:"ObjectString"`
}

// CreateGetSceneDataRequest creates a request to invoke GetSceneData API
func CreateGetSceneDataRequest() (request *GetSceneDataRequest) {
	request = &GetSceneDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("tdsr", "2020-01-01", "GetSceneData", "", "")
	request.Method = requests.POST
	return
}

// CreateGetSceneDataResponse creates a response to parse from GetSceneData response
func CreateGetSceneDataResponse() (response *GetSceneDataResponse) {
	response = &GetSceneDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
