/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.util.j2me;

import com.sun.cldc.util.TimeZoneImplementation;
import java.util.TimeZone;

public class TimeZoneImpl
extends TimeZoneImplementation {
    static String HOME_ID = null;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final int ONE_DAY = 86400000;
    private String ID;
    static String[] ids = null;
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int endMonth;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int startYear;
    private int rawOffset;
    private boolean useDaylight = false;
    private static final int millisPerHour = 3600000;
    private static final int millisPerDay = 86400000;
    private final byte[] monthLength = staticMonthLength;
    private static final byte[] staticMonthLength = new byte[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private int startMode;
    private int endMode;
    private int dstSavings;
    private static final int DOM_MODE = 1;
    private static final int DOW_IN_MONTH_MODE = 2;
    private static final int DOW_GE_DOM_MODE = 3;
    private static final int DOW_LE_DOM_MODE = 4;
    static TimeZone[] zones = new TimeZone[]{new TimeZoneImpl(0, "GMT"), new TimeZoneImpl(0, "UTC")};

    public TimeZoneImpl() {
    }

    private TimeZoneImpl(int rawOffset, String ID) {
        this.rawOffset = rawOffset;
        this.ID = ID;
        this.dstSavings = 3600000;
    }

    private TimeZoneImpl(int rawOffset, String ID, int startMonth, int startDay, int startDayOfWeek, int startTime, int endMonth, int endDay, int endDayOfWeek, int endTime, int dstSavings) {
        this.ID = ID;
        this.rawOffset = rawOffset;
        this.startMonth = startMonth;
        this.startDay = startDay;
        this.startDayOfWeek = startDayOfWeek;
        this.startTime = startTime;
        this.endMonth = endMonth;
        this.endDay = endDay;
        this.endDayOfWeek = endDayOfWeek;
        this.endTime = endTime;
        this.dstSavings = dstSavings;
        this.decodeRules();
        if (dstSavings <= 0) {
            throw new IllegalArgumentException("Illegal DST savings");
        }
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis) {
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException("Illegal month " + month);
        }
        return this.getOffset(era, year, month, day, dayOfWeek, millis, staticMonthLength[month]);
    }

    int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis, int monthLength) {
        if (era != 0 && era != 1 || month < 0 || month > 11 || day < 1 || day > monthLength || dayOfWeek < 1 || dayOfWeek > 7 || millis < 0 || millis >= 86400000 || monthLength < 28 || monthLength > 31) {
            throw new IllegalArgumentException();
        }
        int result = this.rawOffset;
        if (!this.useDaylight || year < this.startYear || era != 1) {
            return result;
        }
        boolean southern = this.startMonth > this.endMonth;
        int startCompare = TimeZoneImpl.compareToRule(month, monthLength, day, dayOfWeek, millis, this.startMode, this.startMonth, this.startDayOfWeek, this.startDay, this.startTime);
        int endCompare = 0;
        if (southern != startCompare >= 0) {
            millis += this.dstSavings;
            while (millis >= 86400000) {
                millis -= 86400000;
                dayOfWeek = 1 + dayOfWeek % 7;
                if (++day <= monthLength) continue;
                day = 1;
                ++month;
            }
            endCompare = TimeZoneImpl.compareToRule(month, monthLength, day, dayOfWeek, millis, this.endMode, this.endMonth, this.endDayOfWeek, this.endDay, this.endTime);
        }
        if (!southern && startCompare >= 0 && endCompare < 0 || southern && (startCompare >= 0 || endCompare < 0)) {
            result += this.dstSavings;
        }
        return result;
    }

    private static int compareToRule(int month, int monthLen, int dayOfMonth, int dayOfWeek, int millis, int ruleMode, int ruleMonth, int ruleDayOfWeek, int ruleDay, int ruleMillis) {
        if (month < ruleMonth) {
            return -1;
        }
        if (month > ruleMonth) {
            return 1;
        }
        int ruleDayOfMonth = 0;
        switch (ruleMode) {
            case 1: {
                ruleDayOfMonth = ruleDay;
                break;
            }
            case 2: {
                if (ruleDay > 0) {
                    ruleDayOfMonth = 1 + (ruleDay - 1) * 7 + (7 + ruleDayOfWeek - (dayOfWeek - dayOfMonth + 1)) % 7;
                    break;
                }
                ruleDayOfMonth = monthLen + (ruleDay + 1) * 7 - (7 + (dayOfWeek + monthLen - dayOfMonth) - ruleDayOfWeek) % 7;
                break;
            }
            case 3: {
                ruleDayOfMonth = ruleDay + (49 + ruleDayOfWeek - ruleDay - dayOfWeek + dayOfMonth) % 7;
                break;
            }
            case 4: {
                ruleDayOfMonth = ruleDay - (49 - ruleDayOfWeek + ruleDay + dayOfWeek - dayOfMonth) % 7;
            }
        }
        if (dayOfMonth < ruleDayOfMonth) {
            return -1;
        }
        if (dayOfMonth > ruleDayOfMonth) {
            return 1;
        }
        if (millis < ruleMillis) {
            return -1;
        }
        if (millis > ruleMillis) {
            return 1;
        }
        return 0;
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    public String getID() {
        return this.ID;
    }

    public synchronized TimeZone getInstance(String ID) {
        if (ID == null) {
            if (HOME_ID == null && (HOME_ID = System.getProperty("com.sun.cldc.util.j2me.TimeZoneImpl.timezone")) == null) {
                HOME_ID = "UTC";
            }
            ID = HOME_ID;
        }
        int i = 0;
        while (i < zones.length) {
            if (zones[i].getID().equals(ID)) {
                return zones[i];
            }
            ++i;
        }
        return null;
    }

    public synchronized String[] getIDs() {
        if (ids == null) {
            ids = new String[zones.length];
            int i = 0;
            while (i < zones.length) {
                TimeZoneImpl.ids[i] = zones[i].getID();
                ++i;
            }
        }
        return ids;
    }

    private void decodeRules() {
        this.decodeStartRule();
        this.decodeEndRule();
    }

    private void decodeStartRule() {
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.startDay != 0) {
            if (this.startMonth < 0 || this.startMonth > 11) {
                throw new IllegalArgumentException("Illegal start month " + this.startMonth);
            }
            if (this.startTime < 0 || this.startTime > 86400000) {
                throw new IllegalArgumentException("Illegal start time " + this.startTime);
            }
            if (this.startDayOfWeek == 0) {
                this.startMode = 1;
            } else {
                if (this.startDayOfWeek > 0) {
                    this.startMode = 2;
                } else {
                    this.startDayOfWeek = -this.startDayOfWeek;
                    if (this.startDay > 0) {
                        this.startMode = 3;
                    } else {
                        this.startDay = -this.startDay;
                        this.startMode = 4;
                    }
                }
                if (this.startDayOfWeek > 7) {
                    throw new IllegalArgumentException("Illegal start day of week " + this.startDayOfWeek);
                }
            }
            if (this.startMode == 2) {
                if (this.startDay < -5 || this.startDay > 5) {
                    throw new IllegalArgumentException("Illegal start day of week in month " + this.startDay);
                }
            } else if (this.startDay > staticMonthLength[this.startMonth]) {
                throw new IllegalArgumentException("Illegal start day " + this.startDay);
            }
        }
    }

    private void decodeEndRule() {
        boolean bl = this.useDaylight = this.startDay != 0 && this.endDay != 0;
        if (this.endDay != 0) {
            if (this.endMonth < 0 || this.endMonth > 11) {
                throw new IllegalArgumentException("Illegal end month " + this.endMonth);
            }
            if (this.endTime < 0 || this.endTime > 86400000) {
                throw new IllegalArgumentException("Illegal end time " + this.endTime);
            }
            if (this.endDayOfWeek == 0) {
                this.endMode = 1;
            } else {
                if (this.endDayOfWeek > 0) {
                    this.endMode = 2;
                } else {
                    this.endDayOfWeek = -this.endDayOfWeek;
                    if (this.endDay > 0) {
                        this.endMode = 3;
                    } else {
                        this.endDay = -this.endDay;
                        this.endMode = 4;
                    }
                }
                if (this.endDayOfWeek > 7) {
                    throw new IllegalArgumentException("Illegal end day of week " + this.endDayOfWeek);
                }
            }
            if (this.endMode == 2) {
                if (this.endDay < -5 || this.endDay > 5) {
                    throw new IllegalArgumentException("Illegal end day of week in month " + this.endDay);
                }
            } else if (this.endDay > staticMonthLength[this.endMonth]) {
                throw new IllegalArgumentException("Illegal end day " + this.endDay);
            }
        }
    }
}

