/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.cldc.i18n.j2me;

import com.sun.cldc.i18n.StreamWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class GenericWriter
extends StreamWriter {
    private String enc;
    private int maxCharsPerByte;
    private int id;
    private static int counter = 0;

    public GenericWriter(String enc) throws UnsupportedEncodingException {
        this.enc = enc;
        this.maxCharsPerByte = this.checkEncoding(enc);
        this.id = counter++;
        this.registerCleanup();
    }

    public Writer open(OutputStream out, String enc) throws UnsupportedEncodingException {
        if (!enc.equals(this.enc)) {
            throw new IllegalArgumentException(enc + " not equals " + this.enc);
        }
        return super.open(out, enc);
    }

    public synchronized void write(int c) throws IOException {
        byte[] bytes = this.charToByteArray(new char[]{(char)c}, 1, this.enc, this.id);
        this.out.write(bytes);
    }

    public synchronized void write(char[] cbuf, int off, int len) throws IOException {
        byte[] bytes;
        if (off != 0) {
            char[] temp = new char[len];
            System.arraycopy(cbuf, off, temp, 0, len);
            bytes = this.charToByteArray(temp, len, this.enc, this.id);
        } else {
            bytes = this.charToByteArray(cbuf, len, this.enc, this.id);
        }
        this.out.write(bytes);
    }

    public synchronized void write(String str, int off, int len) throws IOException {
        this.write(str.substring(off, off + len).toCharArray(), 0, len);
    }

    public int sizeOf(char[] cbuf, int off, int len) {
        try {
            if (off != 0) {
                char[] temp = new char[len];
                System.arraycopy(cbuf, off, temp, 0, len);
                return this.sizeOf(temp, len, this.enc);
            }
            return this.sizeOf(cbuf, len, this.enc);
        }
        catch (IOException e) {
            return -1;
        }
    }

    private native byte[] charToByteArray(char[] var1, int var2, String var3, int var4) throws IOException;

    private native int sizeOf(char[] var1, int var2, String var3) throws IOException;

    private native int checkEncoding(String var1) throws UnsupportedEncodingException;

    private native void registerCleanup();
}

