/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Layout;
import javax.microedition.lcdui.StringItem;

class TaGLayout
implements Layout {
    private static final int GROW_SIZE = 4;
    private Item[] items;
    private int numItems;
    private short[] lineBreaks = new short[]{0, 0};
    private int numLines;
    private int width = -1;
    private int height;
    private int minHeight = -1;
    private int maxHeight = -1;
    private Font f;
    private int lineHeight;

    TaGLayout(Font font) {
        this.f = font;
        this.lineHeight = font.getHeight();
        this.items = new Item[4];
    }

    int getSize() {
        return this.numItems;
    }

    int set(Item oldItem, Item item) {
        int index = this.get(oldItem);
        item.layouts[0] = this;
        this.items[index] = item;
        return this.updateContent(index);
    }

    int insert(Item nextItem, Item item) {
        int index;
        int n = index = nextItem == null ? this.numItems : this.get(nextItem);
        if (this.numItems == this.items.length) {
            Item[] newItems = new Item[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, index);
            System.arraycopy(this.items, index, newItems, index + 1, this.numItems - index);
            this.items = newItems;
        } else {
            System.arraycopy(this.items, index, this.items, index + 1, this.numItems - index);
        }
        item.layouts[0] = this;
        this.items[index] = item;
        ++this.numItems;
        return this.updateContent(index);
    }

    int delete(Item item) {
        item.layouts[0] = null;
        int index = this.get(item);
        if (this.numItems > 1 && index != this.numItems - 1) {
            System.arraycopy(this.items, index + 1, this.items, index, this.numItems - index - 1);
        }
        --this.numItems;
        this.items[this.numItems] = null;
        return this.updateContent(index);
    }

    int get(Item item) {
        int i = 0;
        while (i < this.numItems) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void paint(Graphics g, boolean eraseBgrnd, boolean inverted) {
        if (this.numLines <= 0) {
            return;
        }
        int from = 0;
        int y = g.getClipY();
        if (y > this.height) {
            return;
        }
        int yEnd = y + g.getClipHeight();
        if (yEnd > this.height) {
            yEnd = this.height;
        }
        if (y < 0) {
            y = 0;
        } else if (y > 0) {
            from = y / this.lineHeight;
            if (from >= this.numLines) {
                return;
            }
            y = from * this.lineHeight;
            if (y > yEnd) {
                return;
            }
        }
        if (eraseBgrnd) {
            g.setColor(inverted ? 0 : Display.ERASE_COLOR);
            g.fillRect(0, y, this.width, yEnd);
        }
        g.setFont(this.f);
        g.setColor(inverted ? Display.FG_H_COLOR : 0);
        int nextIndex = 0;
        int nextOffset = 0;
        int next = 0;
        if (from > 0) {
            next = 2 * (from - 1);
            nextIndex = this.lineBreaks[next++];
            nextOffset = this.lineBreaks[next++];
        }
        if (this.items[nextIndex / 2] instanceof ImageItem && nextIndex != 0 && nextIndex % 2 != 0) {
            y -= nextOffset;
            if ((from -= nextOffset / this.lineHeight) == 0) {
                nextOffset = 0;
                nextIndex = 0;
                next = 0;
            } else {
                next = 2 * (from - 1);
                nextIndex = this.lineBreaks[next++];
                nextOffset = this.lineBreaks[next++];
            }
        }
        int xOffset = 0;
        y -= this.lineHeight;
        int j = nextIndex;
        int offset = nextOffset;
        while (j < 2 * this.numItems) {
            if (j < nextIndex) {
                if (++j >= 2 * this.numItems) break;
                offset = 0;
            }
            if (j == nextIndex && offset == nextOffset) {
                if (y > yEnd || next > 2 * this.numLines) break;
                xOffset = 0;
                y += this.lineHeight;
                nextIndex = this.lineBreaks[next++];
                nextOffset = this.lineBreaks[next++];
            }
            Item item = this.items[j / 2];
            Object obj = null;
            if (j % 2 == 0) {
                obj = item.getLabel();
            } else if (item instanceof StringItem) {
                obj = ((StringItem)item).getText();
            } else if (item instanceof ImageItem) {
                obj = ((ImageItem)item).getImage();
            }
            if (obj == null) continue;
            if (obj instanceof Image) {
                Image img = (Image)obj;
                int imgWidth = img.getWidth();
                int imgHeight = img.getHeight();
                int layout = ((ImageItem)item).getLayout();
                int rowsInImage = (imgHeight - offset + this.lineHeight - 1) / this.lineHeight;
                if ((layout & 0x100) != 0 && (layout & 0x200) != 0) {
                    if ((layout &= 3) == 3) {
                        xOffset += Math.max(0, (this.width - xOffset - imgWidth) / 2);
                    } else if (layout == 2) {
                        xOffset += Math.max(0, this.width - xOffset - imgWidth);
                    }
                }
                int vPadding = ((imgHeight + this.lineHeight - 1) / this.lineHeight * this.lineHeight - imgHeight) / 2;
                g.drawImage(img, xOffset, y - offset + vPadding, 20);
                if (rowsInImage > 1) {
                    next += 2 * (rowsInImage - 2);
                    y += (rowsInImage - 1) * this.lineHeight;
                    nextIndex = this.lineBreaks[next++];
                    nextOffset = this.lineBreaks[next++];
                }
                xOffset += img.getWidth();
                offset = 0;
                continue;
            }
            if (!(obj instanceof String)) continue;
            String str = (String)obj;
            int subStrLen = 0;
            subStrLen = next < 2 * this.numLines && j == nextIndex ? nextOffset - offset : str.length() - offset;
            if (subStrLen > 0 && str.charAt(offset) != '\n') {
                int subStrLenWithLf = subStrLen;
                int last = offset + subStrLen - 1;
                while (last >= offset) {
                    if (str.charAt(last) != '\n' && str.charAt(last) != '\r') break;
                    --subStrLenWithLf;
                    --last;
                }
                if (subStrLenWithLf > 0) {
                    g.drawSubstring(str, offset, subStrLenWithLf, xOffset, y, 20);
                    xOffset += this.f.substringWidth(str, offset, subStrLenWithLf);
                }
            }
            offset += subStrLen;
        }
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int setWidth(int w) {
        if (this.width != w && w >= 0) {
            this.width = w;
            if (w == 0) {
                this.numLines = 0;
            } else if (w > 0) {
                this.updateLineBreaks(w);
            }
            this.height = this.numLines * this.lineHeight;
            if (this.minHeight != -1 && this.height < this.minHeight) {
                this.height = this.minHeight;
            }
            if (this.maxHeight != -1 && this.height > this.maxHeight) {
                this.height = this.maxHeight;
            }
        }
        return this.height;
    }

    void setMinHeight(int h) {
        if (h < 0) {
            h = 0;
        }
        this.minHeight = h;
        if (this.height < this.minHeight) {
            this.height = this.minHeight;
        }
    }

    public void setMaxHeight(int h) {
        if (h < 0) {
            h = 0;
        }
        this.maxHeight = h;
        if (this.height > this.maxHeight) {
            this.height = this.maxHeight;
        }
    }

    int itemContentChanged(Item item) {
        return this.updateContent(this.get(item));
    }

    private int addBreak(short index, short offset, int last) {
        if (last + 1 < this.lineBreaks.length) {
            short[] newBreaks = new short[this.lineBreaks.length + 4];
            System.arraycopy(this.lineBreaks, 0, newBreaks, 0, this.lineBreaks.length);
            this.lineBreaks = newBreaks;
        }
        this.lineBreaks[last++] = index;
        this.lineBreaks[last++] = offset;
        return last;
    }

    private void updateLineBreaks(int width) {
        if (this.numItems == 0 || width <= 0) {
            this.height = this.maxHeight > 0 ? this.maxHeight : 0;
            this.lineBreaks[1] = 0;
            this.lineBreaks[0] = 0;
            this.numLines = 0;
            return;
        }
        this.numLines = 0;
        int curWidth = 0;
        int lastIndex = 0;
        int i = 0;
        while (i < 2 * this.numItems) {
            block23: {
                String str;
                int strLength;
                Object obj;
                block24: {
                    boolean addNewLineBefore;
                    int imgWidth;
                    block25: {
                        boolean addNewLineAfter;
                        Item item = this.items[i / 2];
                        obj = null;
                        if (i % 2 == 0) {
                            obj = item.getLabel();
                            if (obj != null && !((String)obj).equals("") && curWidth != 0) {
                                lastIndex = this.addBreak((short)i, (short)0, lastIndex);
                                ++this.numLines;
                                curWidth = 0;
                            }
                        } else if (item instanceof StringItem) {
                            obj = ((StringItem)item).getText();
                        } else if (item instanceof ImageItem) {
                            obj = ((ImageItem)item).getImage();
                        }
                        if (obj == null) break block23;
                        if (!(obj instanceof Image)) break block24;
                        Image img = (Image)obj;
                        imgWidth = img.getWidth();
                        int imgHeight = img.getHeight();
                        int layout = ((ImageItem)item).getLayout();
                        addNewLineBefore = (layout & 0x100) != 0 || curWidth + imgWidth > width;
                        boolean bl = addNewLineAfter = (layout & 0x200) != 0 && i < 2 * this.numItems - 1;
                        if (!addNewLineBefore && !addNewLineAfter) {
                            curWidth += imgWidth;
                        }
                        if (!addNewLineBefore && !addNewLineAfter && imgHeight <= this.lineHeight) break block23;
                        int heightOffset = 0;
                        if (addNewLineBefore && curWidth == 0 || !addNewLineBefore) {
                            heightOffset = this.lineHeight;
                        }
                        while (heightOffset < imgHeight) {
                            lastIndex = this.addBreak((short)i, (short)heightOffset, lastIndex);
                            ++this.numLines;
                            heightOffset += this.lineHeight;
                        }
                        if (!addNewLineAfter) break block25;
                        lastIndex = this.addBreak((short)(i + 1), (short)0, lastIndex);
                        ++this.numLines;
                        curWidth = 0;
                        break block23;
                    }
                    if (!addNewLineBefore) break block23;
                    curWidth = imgWidth;
                    break block23;
                }
                if (obj instanceof String && (strLength = (str = (String)obj).length()) != 0) {
                    int wordWidth = 0;
                    int spaceIndex = -1;
                    int j = 0;
                    while (j < strLength) {
                        char ch = str.charAt(j);
                        int charWidth = this.f.charWidth(ch);
                        if (ch == '\n') {
                            lastIndex = j == strLength - 1 ? this.addBreak((short)(i + 1), (short)0, lastIndex) : this.addBreak((short)i, (short)(j + 1), lastIndex);
                            ++this.numLines;
                            wordWidth = 0;
                            curWidth = 0;
                            spaceIndex = -1;
                        } else {
                            if (ch == ' ') {
                                spaceIndex = j;
                                wordWidth = 0;
                            } else {
                                wordWidth += charWidth;
                            }
                            if ((curWidth += charWidth) > width) {
                                if (wordWidth > width) {
                                    lastIndex = this.addBreak((short)i, (short)j, lastIndex);
                                    curWidth = wordWidth = charWidth;
                                } else {
                                    lastIndex = this.addBreak((short)i, (short)(spaceIndex + 1), lastIndex);
                                    if (j == spaceIndex) {
                                        wordWidth = 0;
                                    }
                                    curWidth = wordWidth;
                                }
                                ++this.numLines;
                                spaceIndex = -1;
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        this.addBreak((short)(2 * this.numItems), (short)0, lastIndex);
        ++this.numLines;
        this.height = this.numLines * this.lineHeight;
        if (this.minHeight != -1 && this.height < this.minHeight) {
            this.height = this.minHeight;
        }
        if (this.maxHeight != -1 && this.height > this.maxHeight) {
            this.height = this.maxHeight;
        }
    }

    private int updateContent(int index) {
        if (this.width <= 0) {
            return 0;
        }
        int oldHeight = this.height;
        if (index == 0 || this.numLines == 0) {
            this.updateLineBreaks(this.width);
            return this.height - oldHeight;
        }
        int line = 0;
        while (line < this.numLines) {
            int nextIndex;
            int n = nextIndex = line + 1 < this.numLines ? this.lineBreaks[line + 1] : this.numItems;
            if (index > nextIndex && line > 0) {
                --line;
            }
            if (index >= nextIndex) {
                if (line > 0) {
                    --line;
                }
                this.updateLineBreaks(this.width);
                return this.height - oldHeight;
            }
            ++line;
        }
        this.updateLineBreaks(this.width);
        return this.height - oldHeight;
    }
}

