/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;

public class Execute {
    public static final int INVALID = Integer.MAX_VALUE;
    private String[] cmdl = null;
    private String[] env = null;
    private int exitValue = Integer.MAX_VALUE;
    private ExecuteStreamHandler streamHandler;
    private ExecuteWatchdog watchdog;
    private File workingDirectory = null;
    private Project project = null;
    private boolean newEnvironment = false;
    private boolean useVMLauncher = true;
    private static String antWorkingDirectory = System.getProperty("user.dir");
    private static CommandLauncher vmLauncher = null;
    private static CommandLauncher shellLauncher = null;
    private static Vector procEnvironment = null;

    public static synchronized Vector getProcEnvironment() {
        if (procEnvironment != null) {
            return procEnvironment;
        }
        procEnvironment = new Vector();
        try {
            String string;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Execute execute = new Execute(new PumpStreamHandler(byteArrayOutputStream));
            execute.setCommandline(Execute.getProcEnvCommand());
            execute.setNewenvironment(true);
            int n = execute.execute();
            if (n != 0) {
                // empty if block
            }
            BufferedReader bufferedReader = new BufferedReader(new StringReader(byteArrayOutputStream.toString()));
            String string2 = null;
            String string3 = System.getProperty("line.separator");
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf(61) == -1) {
                    if (string2 == null) {
                        string2 = string3 + string;
                        continue;
                    }
                    string2 = string2 + string3 + string;
                    continue;
                }
                if (string2 != null) {
                    procEnvironment.addElement(string2);
                }
                string2 = string;
            }
            procEnvironment.addElement(string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return procEnvironment;
    }

    private static String[] getProcEnvCommand() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("mac os") >= 0) {
            String string2;
            try {
                string2 = System.getProperty("os.version");
                int n = Integer.parseInt(string2.substring(0, string2.indexOf(46)));
                if (n >= 10) {
                    String[] stringArray = new String[]{"/usr/bin/env"};
                    return stringArray;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            string2 = null;
            return string2;
        }
        if (string.indexOf("os/2") >= 0) {
            String[] stringArray = new String[]{"cmd", "/c", "set"};
            return stringArray;
        }
        if (string.indexOf("indows") >= 0) {
            if (string.indexOf("nt") >= 0 || string.indexOf("2000") >= 0) {
                String[] stringArray = new String[]{"cmd", "/c", "set"};
                return stringArray;
            }
            String[] stringArray = new String[]{"command.com", "/c", "set"};
            return stringArray;
        }
        String[] stringArray = new String[]{"/usr/bin/env"};
        return stringArray;
    }

    public Execute() {
        this(new PumpStreamHandler(), null);
    }

    public Execute(ExecuteStreamHandler executeStreamHandler) {
        this(executeStreamHandler, null);
    }

    public Execute(ExecuteStreamHandler executeStreamHandler, ExecuteWatchdog executeWatchdog) {
        this.streamHandler = executeStreamHandler;
        this.watchdog = executeWatchdog;
    }

    public String[] getCommandline() {
        return this.cmdl;
    }

    public void setCommandline(String[] stringArray) {
        this.cmdl = stringArray;
    }

    public void setNewenvironment(boolean bl) {
        this.newEnvironment = bl;
    }

    public String[] getEnvironment() {
        if (this.env == null || this.newEnvironment) {
            return this.env;
        }
        return this.patchEnvironment();
    }

    public void setEnvironment(String[] stringArray) {
        this.env = stringArray;
    }

    public void setWorkingDirectory(File file) {
        this.workingDirectory = file == null || file.getAbsolutePath().equals(antWorkingDirectory) ? null : file;
    }

    public void setAntRun(Project project) throws BuildException {
        this.project = project;
    }

    public void setVMLauncher(boolean bl) {
        this.useVMLauncher = bl;
    }

    public int execute() throws IOException {
        CommandLauncher commandLauncher;
        CommandLauncher commandLauncher2 = commandLauncher = vmLauncher != null ? vmLauncher : shellLauncher;
        if (!this.useVMLauncher) {
            commandLauncher = shellLauncher;
        }
        Process process = commandLauncher.exec(this.project, this.getCommandline(), this.getEnvironment(), this.workingDirectory);
        try {
            this.streamHandler.setProcessInputStream(process.getOutputStream());
            this.streamHandler.setProcessOutputStream(process.getInputStream());
            this.streamHandler.setProcessErrorStream(process.getErrorStream());
        }
        catch (IOException iOException) {
            process.destroy();
            throw iOException;
        }
        this.streamHandler.start();
        if (this.watchdog != null) {
            this.watchdog.start(process);
        }
        this.waitFor(process);
        if (this.watchdog != null) {
            this.watchdog.stop();
        }
        this.streamHandler.stop();
        if (this.watchdog != null) {
            this.watchdog.checkException();
        }
        return this.getExitValue();
    }

    protected void waitFor(Process process) {
        try {
            process.waitFor();
            this.setExitValue(process.exitValue());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void setExitValue(int n) {
        this.exitValue = n;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    private String[] patchEnvironment() {
        Vector vector = (Vector)Execute.getProcEnvironment().clone();
        int n = 0;
        while (n < this.env.length) {
            int n2 = this.env[n].indexOf(61);
            String string = this.env[n].substring(0, n2 + 1);
            int n3 = vector.size();
            int n4 = 0;
            while (n4 < n3) {
                if (((String)vector.elementAt(n4)).startsWith(string)) {
                    vector.removeElementAt(n4);
                    break;
                }
                ++n4;
            }
            vector.addElement(this.env[n]);
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void runCommand(Task task, String[] stringArray) throws BuildException {
        try {
            task.log(Commandline.toString(stringArray), 3);
            Execute execute = new Execute(new LogStreamHandler(task, 2, 0));
            execute.setAntRun(task.getProject());
            execute.setCommandline(stringArray);
            int n = execute.execute();
            if (n != 0) {
                throw new BuildException(stringArray[0] + " failed with return code " + n, task.getLocation());
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Could not launch " + stringArray[0] + ": " + iOException, task.getLocation());
        }
    }

    static {
        try {
            vmLauncher = new Java13CommandLauncher();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("mac os") >= 0) {
            shellLauncher = new MacCommandLauncher(new CommandLauncher());
        } else if (string.indexOf("os/2") >= 0) {
            shellLauncher = new WinNTCommandLauncher(new CommandLauncher());
        } else if (string.indexOf("windows") >= 0) {
            CommandLauncher commandLauncher = System.getProperty("java.version").startsWith("1.1") ? new Java11CommandLauncher() : new CommandLauncher();
            shellLauncher = string.indexOf("nt") >= 0 || string.indexOf("2000") >= 0 ? new WinNTCommandLauncher(commandLauncher) : new ScriptCommandLauncher("bin/antRun.bat", commandLauncher);
        } else {
            shellLauncher = new ScriptCommandLauncher("bin/antRun", new CommandLauncher());
        }
    }

    private static class ScriptCommandLauncher
    extends CommandLauncherProxy {
        private String _script;

        ScriptCommandLauncher(String string, CommandLauncher commandLauncher) {
            super(commandLauncher);
            this._script = string;
        }

        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            if (project == null) {
                if (file == null) {
                    return this.exec(project, stringArray, stringArray2);
                }
                throw new IOException("Cannot locate antRun script: No project provided");
            }
            String string = project.getProperty("ant.home");
            if (string == null) {
                throw new IOException("Cannot locate antRun script: Property 'ant.home' not found");
            }
            String string2 = project.resolveFile(string + File.separator + this._script).toString();
            File file2 = file;
            if (file == null && project != null) {
                file2 = project.getBaseDir();
            }
            String[] stringArray3 = new String[stringArray.length + 2];
            stringArray3[0] = string2;
            stringArray3[1] = file2.getAbsolutePath();
            System.arraycopy(stringArray, 0, stringArray3, 2, stringArray.length);
            return this.exec(project, stringArray3, stringArray2);
        }
    }

    private static class MacCommandLauncher
    extends CommandLauncherProxy {
        MacCommandLauncher(CommandLauncher commandLauncher) {
            super(commandLauncher);
        }

        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            Process process;
            if (file == null) {
                return this.exec(project, stringArray, stringArray2);
            }
            ((Hashtable)System.getProperties()).put("user.dir", file.getAbsolutePath());
            try {
                process = this.exec(project, stringArray, stringArray2);
                Object var7_6 = null;
                ((Hashtable)System.getProperties()).put("user.dir", antWorkingDirectory);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                ((Hashtable)System.getProperties()).put("user.dir", antWorkingDirectory);
                throw throwable;
            }
            return process;
        }
    }

    private static class WinNTCommandLauncher
    extends CommandLauncherProxy {
        WinNTCommandLauncher(CommandLauncher commandLauncher) {
            super(commandLauncher);
        }

        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            File file2 = file;
            if (file == null) {
                if (project != null) {
                    file2 = project.getBaseDir();
                } else {
                    return this.exec(project, stringArray, stringArray2);
                }
            }
            String[] stringArray3 = new String[stringArray.length + 6];
            stringArray3[0] = "cmd";
            stringArray3[1] = "/c";
            stringArray3[2] = "cd";
            stringArray3[3] = "/d";
            stringArray3[4] = file2.getAbsolutePath();
            stringArray3[5] = "&&";
            System.arraycopy(stringArray, 0, stringArray3, 6, stringArray.length);
            return this.exec(project, stringArray3, stringArray2);
        }
    }

    private static class CommandLauncherProxy
    extends CommandLauncher {
        private CommandLauncher _launcher;

        CommandLauncherProxy(CommandLauncher commandLauncher) {
            this._launcher = commandLauncher;
        }

        public Process exec(Project project, String[] stringArray, String[] stringArray2) throws IOException {
            return this._launcher.exec(project, stringArray, stringArray2);
        }
    }

    private static class Java13CommandLauncher
    extends CommandLauncher {
        private Method _execWithCWD = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = Java13CommandLauncher.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("exec", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Java13CommandLauncher.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, array$Ljava$lang$String == null ? (array$Ljava$lang$String = Java13CommandLauncher.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$java$io$File == null ? (class$java$io$File = Java13CommandLauncher.class$("java.io.File")) : class$java$io$File);
        static /* synthetic */ Class array$Ljava$lang$String;
        static /* synthetic */ Class class$java$io$File;
        static /* synthetic */ Class class$java$lang$Runtime;

        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            try {
                if (project != null) {
                    project.log("Execute:Java13CommandLauncher: " + Commandline.toString(stringArray), 4);
                }
                Object[] objectArray = new Object[]{stringArray, stringArray2, file};
                return (Process)this._execWithCWD.invoke((Object)Runtime.getRuntime(), objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new BuildException("Unable to execute command", throwable);
            }
            catch (Exception exception) {
                throw new BuildException("Unable to execute command", exception);
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private static class Java11CommandLauncher
    extends CommandLauncher {
        private Java11CommandLauncher() {
        }

        public Process exec(Project project, String[] stringArray, String[] stringArray2) throws IOException {
            String[] stringArray3 = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray3[n] = Commandline.quoteArgument(stringArray[n]);
                ++n;
            }
            if (project != null) {
                project.log("Execute:Java11CommandLauncher: " + Commandline.toString(stringArray3), 4);
            }
            return Runtime.getRuntime().exec(stringArray3, stringArray2);
        }
    }

    private static class CommandLauncher {
        private CommandLauncher() {
        }

        public Process exec(Project project, String[] stringArray, String[] stringArray2) throws IOException {
            if (project != null) {
                project.log("Execute:CommandLauncher: " + Commandline.toString(stringArray), 4);
            }
            return Runtime.getRuntime().exec(stringArray, stringArray2);
        }

        public Process exec(Project project, String[] stringArray, String[] stringArray2, File file) throws IOException {
            if (file == null) {
                return this.exec(project, stringArray, stringArray2);
            }
            throw new IOException("Cannot execute a process in different directory under this JVM");
        }
    }
}

