DEF_CF( cfunc_nop,     "nop\n" )
DEF_CF( cfunc_quit,    "quit /return val\n" )
DEF_CF( cfunc_halt,    "halt\n" )
DEF_CF( cfunc_exit,    "exit\n" )
DEF_CF( cfunc_return,  "return val\n" )
DEF_CF( cfunc_break,   "break\n" )
DEF_CF( cfunc_continue,"continue\n" )
DEF_CF( cfunc_throw,   "throw val /name w word! /no-trace\n" )
DEF_CF( cfunc_catch,   "catch val block! /name w word!/block!\n" )
DEF_CF( cfunc_try,     "try val block!\n" )
DEF_CF( cfunc_recycle, "recycle\n" )
DEF_CF( cfunc_do,      "do eval\n" )
DEF_CF( cfunc_set,     "set w val\n" )
DEF_CF( cfunc_get,     "get w\n" )
DEF_CF( cfunc_valueQ,  "value? w\n" )
DEF_CF( cfunc_in,      "in c context! w\n" )
DEF_CF( cfunc_words_of,"words-of c context! 0\n" )
DEF_CF( cfunc_words_of,"values-of c context!/hash-map! 1\n" )
DEF_CF( cfunc_bindingQ,"binding? w\n" )
DEF_CF( cfunc_bind,    "bind b w /secure\n" )
DEF_CF( cfunc_unbind,  "unbind w /deep\n" )
DEF_CF( cfunc_infuse,  "infuse b block! w\n" )
DEF_CF( cfunc_add,     "add a b\n" )
DEF_CF( cfunc_sub,     "sub a b\n" )
DEF_CF( cfunc_mul,     "mul a b\n" )
DEF_CF( cfunc_div,     "div a b\n" )
DEF_CF( cfunc_mod,     "mod a b\n" )
DEF_CF( cfunc_and,     "and a b\n" )
DEF_CF( cfunc_or,      "or a b\n" )
DEF_CF( cfunc_xor,     "xor a b\n" )
DEF_CF( cfunc_minimum, "minimum a b\n" )
DEF_CF( cfunc_maximum, "maximum a b\n" )
DEF_CF( cfunc_abs,     "abs n\n" )
DEF_CF( cfunc_sqrt,    "sqrt n int!/double!\n" )
DEF_CF( cfunc_cos,     "cos n int!/double!\n" )
DEF_CF( cfunc_sin,     "sin n int!/double!\n" )
DEF_CF( cfunc_atan,    "atan n int!/double!/coord!/vec3!\n" )
DEF_CF( cfunc_make,    "make type spec\n" )
DEF_CF( cfunc_copy,    "copy val /deep\n" )
DEF_CF( cfunc_reserve, "reserve ser size int!\n" )
DEF_CF( cfunc_does,    "does body block!\n" )
DEF_CF( cfunc_func,    "func spec block! body block!\n" )
DEF_CF( cfunc_mold,    "mold val /contents\n" )
DEF_CF( cfunc_probe,   "probe val\n" )
DEF_CF( cfunc_prin,    "prin val\n" )
DEF_CF( cfunc_print,   "print val\n" )
DEF_CF( cfunc_to_text, "to-text val\n" )
DEF_CF( cfunc_all,     "all val block!\n" )
DEF_CF( cfunc_any,     "any val block!\n" )
DEF_CF( cfunc_reduce,  "reduce val\n" )
DEF_CF( cfunc_not,     "not val\n" )
DEF_CF( cfunc_if,      "if exp body /no-trace\n" )
DEF_CF( cfunc_ifn,     "ifn exp body /no-trace\n" )
DEF_CF( cfunc_either,  "either exp a b /no-trace\n" )
DEF_CF( cfunc_while,   "while exp block! body block! /no-trace\n" )
DEF_CF( cfunc_forever, "forever body block! /no-trace\n" )
DEF_CF( cfunc_loop,    "loop n int!/block! body block! /no-trace\n" )
DEF_CF( cfunc_select,  "select data val /last /case\n" )
DEF_CF( cfunc_switch,  "switch val body block!\n" )
DEF_CF( cfunc_case,    "case body block!\n" )
DEF_CF( cfunc_first,   "first ser\n" )
DEF_CF( cfunc_second,  "second ser 1\n" )
DEF_CF( cfunc_second,  "third ser 2\n" )
DEF_CF( cfunc_last,    "last ser\n" )
DEF_CF( cfunc_2plus,   "++ 'w\n" )
DEF_CF( cfunc_2minus,  "-- 'w\n" )
DEF_CF( cfunc_prev,    "prev ser\n" )
DEF_CF( cfunc_next,    "next ser\n" )
DEF_CF( cfunc_head,    "head ser\n" )
DEF_CF( cfunc_tail,    "tail ser\n" )
DEF_CF( cfunc_pick,    "pick ser n\n" )
DEF_CF( cfunc_poke,    "poke ser n val\n" )
DEF_CF( cfunc_pop,     "pop ser\n" )
DEF_CF( cfunc_skip,    "skip ser n /wrap\n" )
DEF_CF( cfunc_append,  "append ser val /block /repeat a int!\n" )
DEF_CF( cfunc_appair,  "appair ser a b\n" )
DEF_CF( cfunc_insert,  "insert ser val /block /part n /repeat a int!\n" )
DEF_CF( cfunc_change,  "change ser val /slice /part n\n" )
DEF_CF( cfunc_remove,  "remove ser /slice /part n int! /key val\n" )
DEF_CF( cfunc_reverse, "reverse ser /part n int!\n" )
DEF_CF( cfunc_find,    "find ser val /last /case /part n\n" )
DEF_CF( cfunc_clear,   "clear ser\n" )
DEF_CF( cfunc_slice,   "slice ser n\n" )
DEF_CF( cfunc_emptyQ,  "empty? ser\n" )
DEF_CF( cfunc_headQ,   "head? ser\n" )
DEF_CF( cfunc_sizeQ,   "size? ser\n" )
DEF_CF( cfunc_indexQ,     "index? ser\n" )
DEF_CF( cfunc_seriesQ,    "series? ser\n" )
DEF_CF( cfunc_any_blockQ, "any-block? val\n" )
DEF_CF( cfunc_any_wordQ,  "any-word? val\n" )
DEF_CF( cfunc_complement, "complement val\n" )
DEF_CF( cfunc_negate,     "negate n\n" )
DEF_CF( cfunc_intersect,  "intersect a b /case\n" )
DEF_CF( cfunc_difference, "difference a b /case\n" )
DEF_CF( cfunc_union,      "union a b /case\n" )
DEF_CF( cfunc_sort,       "sort ser /case /group size int!"
                            " /field b block!\n" )
DEF_CF( cfunc_foreach,    "foreach 'w s body 0 /no-trace\n" )
DEF_CF( cfunc_foreach,    "remove-each 'w s body 1 /no-trace\n" )
DEF_CF( cfunc_forall,     "forall 'w word! body block! /no-trace\n" )
DEF_CF( cfunc_map,        "map 'w word! ser body block! /no-trace\n" )
DEF_CF( cfunc_infoQ,      "exists? file string!/file! 0\n" )
DEF_CF( cfunc_infoQ,      "dir? file string!/file! 1\n" )
DEF_CF( cfunc_infoQ,      "info? file string!/file! 2\n" )
DEF_CF( cfunc_make_dir,   "make-dir path string!/file! /all\n" )
DEF_CF( cfunc_change_dir, "change-dir path string!/file!\n" )
DEF_CF( cfunc_current_dir,"current-dir\n" )
DEF_CF( cfunc_getenv,     "getenv name string!\n" )
DEF_CF( cfunc_setenv,     "setenv name string! val\n" )
DEF_CF( cfunc_open,       "open from /read /write /new /nowait\n" )
DEF_CF( cfunc_read,       "read from /text /into b /append a"
                            " /part size int!\n" )
DEF_CF( cfunc_write,      "write to data /append /text\n" )
DEF_CF( cfunc_delete,     "delete file string!/file!\n" )
DEF_CF( cfunc_rename,     "rename a string!/file! b string!/file!\n" )
DEF_CF( cfunc_load,       "load from\n" )
DEF_CF( cfunc_save,       "save to data\n" )
DEF_CF( cfunc_split,      "split a b /keep\n" )
DEF_CF( cfunc_parse,      "parse input binary!/string!/block!"
                            " rules block! /case\n" )
DEF_CF( cfunc_sameQ,      "same? a b\n" )
DEF_CF( cfunc_equalQ,     "equal? a b\n" )
DEF_CF( cfunc_neQ,        "ne? a b\n" )
DEF_CF( cfunc_gtQ,        "gt? a b\n" )
DEF_CF( cfunc_ltQ,        "lt? a b\n" )
DEF_CF( cfunc_geQ,        "ge? a b\n" )
DEF_CF( cfunc_leQ,        "le? a b\n" )
DEF_CF( cfunc_zeroQ,      "zero? a\n" )
DEF_CF( cfunc_typeQ,      "type? a\n" )
DEF_CF( cfunc_encodingQ,  "encoding? s\n" )
DEF_CF( cfunc_encode,     "encode type s /bom\n" )
DEF_CF( cfunc_decode,     "decode type word! s string!\n" )
DEF_CF( cfunc_swap,       "swap b binary!/block! /group size int!\n" )
DEF_CF( cfunc_lowercase,  "lowercase s\n" )
DEF_CF( cfunc_uppercase,  "uppercase s\n" )
DEF_CF( cfunc_trim,       "trim s string! /indent /lines\n" )
DEF_CF( cfunc_terminate,  "terminate ser val /dir\n" )
DEF_CF( cfunc_to_hex,     "to-hex n\n" )
DEF_CF( cfunc_to_dec,     "to-dec n\n" )
DEF_CF( cfunc_mark_sol,   "mark-sol val /block /clear\n" )
DEF_CF( cfunc_now,        "now /date\n" )
DEF_CF( cfunc_cpu_cycles, "cpu-cycles n int! b block!\n" )
DEF_CF( cfunc_free,       "free s\n" )
DEF_CF( cfunc_serialize,  "serialize b block!\n" )
DEF_CF( cfunc_unserialize,"unserialize b binary!\n" )
DEF_CF( cfunc_collect,    "collect type datatype! a block!/paren!"
                            " /unique /into b block!\n" )
DEF_CF( cfunc_construct,  "construct s b\n" )
DEF_CF( cfunc_sleep,      "sleep n\n" )
DEF_CF( cfunc_wait,       "wait b\n" )
DEF_CF( cfunc_format,     "format s block! a\n" )

#ifdef CONFIG_SOCKET
    DEF_CF( cfunc_set_addr,   "set-addr p host\n" )
    DEF_CF( cfunc_hostname,   "hostname p\n" )
#endif
#ifdef CONFIG_THREAD
    DEF_CF( cfunc_thread,     "thread body /port\n" )
#endif
#ifdef CONFIG_CHECKSUM
    DEF_CF( cfunc_hash,       "hash val\n" )
    DEF_CF( cfunc_checksum,   "checksum val /sha1 /crc16 /crc32\n" )
#endif
#ifdef CONFIG_COMPRESS
    DEF_CF( cfunc_compress,   "compress s\n" )
    DEF_CF( cfunc_decompress, "decompress b\n" )
#endif
#ifdef CONFIG_RANDOM
    DEF_CF( cfunc_random,     "random a /seed\n" )
#endif
#ifdef CONFIG_EXECUTE
    DEF_CF( cfunc_execute,    "execute s /in a /out b /err c /spawn /port\n" )
    DEF_CF( cfunc_with_flock, "with-flock file file! body block! /nowait\n" )
#endif
#ifdef CONFIG_ASSEMBLE
    DEF_CF( cfunc_assemble,   "assemble s block! body block!\n" )
#endif
