/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.inspect;

import charm.debug.inspect.GenericElement;
import charm.debug.inspect.GenericType;
import charm.debug.inspect.TypeVisitor;
import java.nio.ByteBuffer;

public class VariableElement
extends GenericElement {
    String name;
    int size;
    int pointer;

    public VariableElement(GenericType t, String n, int s, int p, int o) {
        this.type = t;
        this.name = n;
        this.size = s;
        this.pointer = p;
        this.offset = o;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPointer() {
        return this.pointer;
    }

    public int getArray() {
        return this.size;
    }

    @Override
    public GenericElement castNewType(GenericType t, int p) {
        return new VariableElement(t, this.name, this.size, p, this.offset);
    }

    @Override
    public boolean equals(GenericElement e) {
        if (!(e instanceof VariableElement)) {
            return false;
        }
        VariableElement ve = (VariableElement)e;
        return this.pointer == ve.pointer && this.type == ve.type;
    }

    public String toString(String indent) {
        StringBuffer buf = new StringBuffer();
        if (this.pointer > 0) {
            buf.append(this.type.getName());
            for (int i = 0; i < this.pointer; ++i) {
                buf.append("*");
            }
        } else {
            buf.append(this.type.toString(indent));
        }
        buf.append(" ").append(this.name);
        if (this.size > 0) {
            buf.append("[").append(this.size).append("]");
        }
        buf.append(" (").append(this.offset).append(")");
        return buf.toString();
    }

    public String memoryToString(String indent, ByteBuffer mem, int start) {
        int newStart;
        StringBuffer buf = new StringBuffer();
        buf.append(this.type.getName());
        for (int i = 0; i < this.pointer; ++i) {
            buf.append("*");
        }
        buf.append(" ").append(this.name);
        if (this.size > 0) {
            buf.append("[").append(this.size).append("]");
        }
        buf.append(" = ");
        int n = newStart = this.offset >= 0 && start >= 0 ? this.offset + start : -1;
        if (this.pointer > 0) {
            buf.append(GenericType.printPointer(mem, newStart));
        } else {
            if (this.size > 0) {
                buf.append("{ ");
            }
            buf.append(this.type.memoryToString(indent, mem, newStart));
            for (int i = 1; i < this.size; ++i) {
                buf.append(", ").append(this.type.memoryToString(indent, mem, newStart >= 0 ? newStart + this.type.getSize() * i : -1));
            }
            if (this.size > 0) {
                buf.append(" }");
            }
        }
        return buf.toString();
    }

    @Override
    public void visit(TypeVisitor v) {
        v.addType(this.type.getName());
        v.addName(this.name);
        int i = this.size;
        if (i == 0) {
            ++i;
        }
        for (int j = 0; j < i; ++j) {
            v.seek(this.offset + j * this.type.getSize());
            this.type.visit(v);
            v.revertSeek();
        }
        if (this.pointer > 0) {
            v.setPointer(this.pointer);
        }
    }
}

