/* hash.h
 *
 * hash header file
 * By Jon Rifkin <jon.rifkin@uconn.edu>
 * Copyright 1999-2005 Jonathan Rifkin
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


#ifndef _HASH_H
#define _HASH_H

#define U_CHAR unsigned char

/* Option flags  */
#define HT_HISTORY 0x1

/*
------------------------------------------------------------------------
Type Definitions
------------------------------------------------------------------------
*/

/*  Individual element  */
typedef struct h_elem_s {
		/*  Key */
		U_CHAR  *key;
		int    nkey;
		/*  Data  */
		U_CHAR  *data;
		int    ndata;
		/*  Links to double linked list for each hash slot  */
		struct helem_s *next, *prev;
		/*  Links for global double linked list for element history  */
		/*  No space needed for these links if no history  */
		struct helem_s *newer, *older;
} helem_t;

/*  Hash  */
typedef struct {
		/*  Number of elements in all lists  */
		int     nelem;
		/*  Array of lists  */
		helem_t **array;
		/*  Size of array of lists  */
		int     narray;
		/*  Number of allocated lists:  nlist <= narray */
		int     nlist;
		/*  Current element,list  - used to find next  */
		helem_t *curelem;
		int      curlist;
		/*  This flag true/false to add new elements to list tail/head  */
		int     AddTail;
		/*  Use history list  */
		int     Options;
		/*  Size of element  */
		int     ElementSize;
		/*  Oldest, newest nodes  */
		helem_t *oldest, *newest;
} htable_t;


/*
------------------------------------------------------------------------
Function Prototypes
------------------------------------------------------------------------
*/

htable_t *ht_init      (int narray, int options);
int       ht_finddata  (htable_t *h, U_CHAR *k, int nk, U_CHAR **d, int *nd);
int       ht_storenode (htable_t *h, U_CHAR *k, int nk, U_CHAR  *d, int  nd);
void      ht_initwalk  (htable_t *h);
helem_t  *ht_getnext   (htable_t *h);
helem_t  *ht_getnewer  (htable_t *h, helem_t *e);
int       ht_getcount  (htable_t *h);
void      ht_free      (htable_t *h);
helem_t  *ht_findelem  (htable_t *h, U_CHAR *k, int nk);
int       ht_gethash   (htable_t *h, U_CHAR *k, int nk);
void      ht_freeelem  (htable_t *h, helem_t  *e);
void      ht_makenewest(htable_t *h, helem_t *);
helem_t  *ht_getoldest (htable_t *h);
void      ht_debuginfo (htable_t *h);
int       ht_storekey  (htable_t *ht, U_CHAR *key, int nkey, U_CHAR  *data, int  ndata);
int       ht_findkey   (htable_t *ht, U_CHAR *key, int nkey, U_CHAR **data, int *ndata);

#endif
