//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmsi

import "time"

// FederatedIdentityCredential - Describes a federated identity credential.
type FederatedIdentityCredential struct {
	// The properties associated with the federated identity credential.
	Properties *FederatedIdentityCredentialProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FederatedIdentityCredentialProperties - The properties associated with a federated identity credential.
type FederatedIdentityCredentialProperties struct {
	// REQUIRED; The list of audiences that can appear in the issued token.
	Audiences []*string `json:"audiences,omitempty"`

	// REQUIRED; The URL of the issuer to be trusted.
	Issuer *string `json:"issuer,omitempty"`

	// REQUIRED; The identifier of the external identity.
	Subject *string `json:"subject,omitempty"`
}

// FederatedIdentityCredentialsClientCreateOrUpdateOptions contains the optional parameters for the FederatedIdentityCredentialsClient.CreateOrUpdate
// method.
type FederatedIdentityCredentialsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// FederatedIdentityCredentialsClientDeleteOptions contains the optional parameters for the FederatedIdentityCredentialsClient.Delete
// method.
type FederatedIdentityCredentialsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// FederatedIdentityCredentialsClientGetOptions contains the optional parameters for the FederatedIdentityCredentialsClient.Get
// method.
type FederatedIdentityCredentialsClientGetOptions struct {
	// placeholder for future optional parameters
}

// FederatedIdentityCredentialsClientListOptions contains the optional parameters for the FederatedIdentityCredentialsClient.NewListPager
// method.
type FederatedIdentityCredentialsClientListOptions struct {
	// A skip token is used to continue retrieving items after an operation returns a partial result. If a previous response contains
	// a nextLink element, the value of the nextLink element will include a
	// skipToken parameter that specifies a starting point to use for subsequent calls.
	Skiptoken *string
	// Number of records to return.
	Top *int32
}

// FederatedIdentityCredentialsListResult - Values returned by the List operation for federated identity credentials.
type FederatedIdentityCredentialsListResult struct {
	// The url to get the next page of results, if any.
	NextLink *string `json:"nextLink,omitempty"`

	// The collection of federated identity credentials returned by the listing operation.
	Value []*FederatedIdentityCredential `json:"value,omitempty"`
}

// Identity - Describes an identity resource.
type Identity struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The properties associated with the identity.
	Properties *UserAssignedIdentityProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IdentityUpdate - Describes an identity resource.
type IdentityUpdate struct {
	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The properties associated with the identity.
	Properties *UserAssignedIdentityProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Operation supported by the Microsoft.ManagedIdentity REST API.
type Operation struct {
	// The object that describes the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// The name of the REST Operation. This is of the format {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
}

// OperationDisplay - The object that describes the operation.
type OperationDisplay struct {
	// A description of the operation.
	Description *string `json:"description,omitempty"`

	// The type of operation. For example: read, write, delete.
	Operation *string `json:"operation,omitempty"`

	// Friendly name of the resource provider.
	Provider *string `json:"provider,omitempty"`

	// The resource type on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - A list of operations supported by Microsoft.ManagedIdentity Resource Provider.
type OperationListResult struct {
	// The url to get the next page of results, if any.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of operations supported by Microsoft.ManagedIdentity Resource Provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.NewListPager method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// SystemAssignedIdentitiesClientGetByScopeOptions contains the optional parameters for the SystemAssignedIdentitiesClient.GetByScope
// method.
type SystemAssignedIdentitiesClientGetByScopeOptions struct {
	// placeholder for future optional parameters
}

// SystemAssignedIdentity - Describes a system assigned identity resource.
type SystemAssignedIdentity struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The properties associated with the identity.
	Properties *SystemAssignedIdentityProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SystemAssignedIdentityProperties - The properties associated with the system assigned identity.
type SystemAssignedIdentityProperties struct {
	// READ-ONLY; The id of the app associated with the identity. This is a random generated UUID by MSI.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The ManagedServiceIdentity DataPlane URL that can be queried to obtain the identity credentials.
	ClientSecretURL *string `json:"clientSecretUrl,omitempty" azure:"ro"`

	// READ-ONLY; The id of the service principal object associated with the created identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The id of the tenant which the identity belongs to.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// UserAssignedIdentitiesClientCreateOrUpdateOptions contains the optional parameters for the UserAssignedIdentitiesClient.CreateOrUpdate
// method.
type UserAssignedIdentitiesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// UserAssignedIdentitiesClientDeleteOptions contains the optional parameters for the UserAssignedIdentitiesClient.Delete
// method.
type UserAssignedIdentitiesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// UserAssignedIdentitiesClientGetOptions contains the optional parameters for the UserAssignedIdentitiesClient.Get method.
type UserAssignedIdentitiesClientGetOptions struct {
	// placeholder for future optional parameters
}

// UserAssignedIdentitiesClientListByResourceGroupOptions contains the optional parameters for the UserAssignedIdentitiesClient.NewListByResourceGroupPager
// method.
type UserAssignedIdentitiesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// UserAssignedIdentitiesClientListBySubscriptionOptions contains the optional parameters for the UserAssignedIdentitiesClient.NewListBySubscriptionPager
// method.
type UserAssignedIdentitiesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// UserAssignedIdentitiesClientUpdateOptions contains the optional parameters for the UserAssignedIdentitiesClient.Update
// method.
type UserAssignedIdentitiesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// UserAssignedIdentitiesListResult - Values returned by the List operation.
type UserAssignedIdentitiesListResult struct {
	// The url to get the next page of results, if any.
	NextLink *string `json:"nextLink,omitempty"`

	// The collection of userAssignedIdentities returned by the listing operation.
	Value []*Identity `json:"value,omitempty"`
}

// UserAssignedIdentityProperties - The properties associated with the user assigned identity.
type UserAssignedIdentityProperties struct {
	// READ-ONLY; The id of the app associated with the identity. This is a random generated UUID by MSI.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The id of the service principal object associated with the created identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The id of the tenant which the identity belongs to.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}
