/*
* Copyright 2018 - Present Okta, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
 */

// Code generated by okta openapi generator. DO NOT EDIT.

package okta

import (
	"context"
	"fmt"
	"time"
)

type ThreatInsightConfigurationResource resource

type ThreatInsightConfiguration struct {
	Links        interface{} `json:"_links,omitempty"`
	Action       string      `json:"action,omitempty"`
	Created      *time.Time  `json:"created,omitempty"`
	ExcludeZones []string    `json:"excludeZones,omitempty"`
	LastUpdated  *time.Time  `json:"lastUpdated,omitempty"`
}

// Gets current ThreatInsight configuration
func (m *ThreatInsightConfigurationResource) GetCurrentConfiguration(ctx context.Context) (*ThreatInsightConfiguration, *Response, error) {
	url := fmt.Sprintf("/api/v1/threats/configuration")

	rq := m.client.CloneRequestExecutor()

	req, err := rq.WithAccept("application/json").WithContentType("application/json").NewRequest("GET", url, nil)
	if err != nil {
		return nil, nil, err
	}

	var threatInsightConfiguration *ThreatInsightConfiguration

	resp, err := rq.Do(ctx, req, &threatInsightConfiguration)
	if err != nil {
		return nil, resp, err
	}

	return threatInsightConfiguration, resp, nil
}

// Updates ThreatInsight configuration
func (m *ThreatInsightConfigurationResource) UpdateConfiguration(ctx context.Context, body ThreatInsightConfiguration) (*ThreatInsightConfiguration, *Response, error) {
	url := fmt.Sprintf("/api/v1/threats/configuration")

	rq := m.client.CloneRequestExecutor()

	req, err := rq.WithAccept("application/json").WithContentType("application/json").NewRequest("POST", url, body)
	if err != nil {
		return nil, nil, err
	}

	var threatInsightConfiguration *ThreatInsightConfiguration

	resp, err := rq.Do(ctx, req, &threatInsightConfiguration)
	if err != nil {
		return nil, resp, err
	}

	return threatInsightConfiguration, resp, nil
}
