import * as React from 'react';
import { QueryParamOptions, QueryParamOptionsWithRequired } from './options';
import { QueryParamAdapter, QueryParamAdapterComponent } from './types';
/**
 * Shape of the QueryParamContext, which the hooks consume to read and
 * update the URL state.
 */
declare type QueryParamContextValue = {
    adapter: QueryParamAdapter;
    options: QueryParamOptionsWithRequired;
};
export declare const QueryParamContext: React.Context<QueryParamContextValue>;
export declare function useQueryParamContext(): QueryParamContextValue;
/**
 * Props for the Provider component, used to hook the active routing
 * system into our controls. Note only the root provider requires
 * `adapter`. We try to encourage that via intellisense by writing
 * the types this way (you must provide at least one of adapter or options,
 * default intellisense suggests adapter required.)
 */
declare type QueryParamProviderProps = {
    /** Main app goes here */
    children: React.ReactNode;
} & ({
    adapter?: never;
    options: QueryParamOptions;
} | {
    /** required for the root provider but not for nested ones */
    adapter: QueryParamAdapterComponent;
    options?: QueryParamOptions;
});
/**
 * Context provider for query params to have access to the
 * active routing system, enabling updates to the URL.
 */
export declare function QueryParamProvider({ children, adapter, options, }: QueryParamProviderProps): JSX.Element;
export default QueryParamProvider;
