/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.id;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ivy.core.LogOptions;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.MapMatcher;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.NoFilter;

public final class ModuleRules {
    private Map rules = new LinkedHashMap();

    public ModuleRules() {
    }

    private ModuleRules(Map map2) {
        this.rules = new LinkedHashMap(map2);
    }

    public final void defineRule(MapMatcher mapMatcher, Object object) {
        LogOptions.checkNotNull(mapMatcher, "condition");
        LogOptions.checkNotNull(object, "rule");
        this.rules.put(mapMatcher, object);
    }

    public final Object[] getRules(ModuleId moduleId) {
        Filter filter2 = NoFilter.INSTANCE;
        Map map2 = moduleId.getAttributes();
        ModuleRules moduleRules = this;
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : moduleRules.rules.entrySet()) {
            Object v;
            if (!((MapMatcher)entry.getKey()).matches(map2) || !filter2.accept(v = entry.getValue())) continue;
            arrayList.add(v);
        }
        return arrayList.toArray();
    }

    public final Object getRule(ModuleId moduleId, Filter filter2) {
        LogOptions.checkNotNull(moduleId, "mid");
        return this.getRule(moduleId.getAttributes(), filter2);
    }

    public final Object getRule(ModuleRevisionId moduleRevisionId, Filter filter2) {
        LogOptions.checkNotNull(moduleRevisionId, "mrid");
        LogOptions.checkNotNull(filter2, "filter");
        Map map2 = moduleRevisionId.getAttributes();
        return this.getRule(map2, filter2);
    }

    private Object getRule(Map map2, Filter filter2) {
        for (Map.Entry entry : this.rules.entrySet()) {
            Object v;
            if (!((MapMatcher)entry.getKey()).matches(map2) || !filter2.accept(v = entry.getValue())) continue;
            return v;
        }
        return null;
    }

    public final void dump(String string) {
        if (this.rules.isEmpty()) {
            Message.debug(string + "NONE");
            return;
        }
        for (MapMatcher mapMatcher : this.rules.keySet()) {
            Object v = this.rules.get(mapMatcher);
            Message.debug(string + mapMatcher + " -> " + v);
        }
    }

    public final Map getAllRules() {
        return Collections.unmodifiableMap(this.rules);
    }

    public final Object clone() {
        return new ModuleRules(this.rules);
    }
}

