/***************************************************************************
 *                                                                         *
 *   br.h        (begin: Feb 20 2003)                                      *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh}@cs.uni-duesseldorf.de                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef BR_H
#define BR_H

#include <iostream>
#include "ali.h"
#include "utl.h"

/*
THE DISCRIPTION OF CLASS Branch
The Branch class contains all information and methods for a branch of a certain tree (topology).
The Branch class can act with two type of data, INTEGER OR DOUBLE, independently.
The default type for this class if double */

template <class T = double>
class Br {
public :
	//constructor function of this class
	Br () {
		id_ = -1;
		isEx_ = -1; //not specified
		isStG_ = 0;
	}

	//--------------------------------------------------------------------
	//clean all content of this branch
	void clean () {
		id_ = -1;
	}

	//--------------------------------------------------------------------
	//set id for this br
	void setId (const int id) {
		id_ = id;
	}

	//--------------------------------------------------------------------
	//get Id of this br
	int getId () {
		return id_;
	}

	//--------------------------------------------------------------------

	//set len value for this br
	void setLen (const T len) {
		len_ = len;
	}

	void turnOffIsEx () {
		isEx_ = 0;
	}

	void turnOnIsEx () {
		isEx_ = 1;
	}

	//--------------------------------------------------------------------
	//put Id and two nds of the br
	void set (const int id, const int ndNo1, const int ndNo2) {
		id_ = id;
		smaNdNo_ = ndNo1;
		greNdNo_ = ndNo2;
		Utl::orderInc (smaNdNo_, greNdNo_);

		int maxNExNd_ = alignment.getNSeq ();
		if ( (greNdNo_ >= maxNExNd_) && (smaNdNo_ >= maxNExNd_) )
			isEx_ = 0;
		else
			isEx_ = 1;
	}

	void convert () {
		isStG_ = 1 - isStG_;
	}

	//--------------------------------------------------------------------
	//put Id and two nds of the br
	void set (const int id, const int ndNo1, const int ndNo2, EX_IN brType) {
		id_ = id;
		smaNdNo_ = ndNo1;
		greNdNo_ = ndNo2;
		Utl::orderInc (smaNdNo_, greNdNo_);

		if (brType == EX)
			isEx_ = 1;
		else
			isEx_ = 0;
	}

	//--------------------------------------------------------------------
	//put id,two nds and the len of the br
	void set (const int id, const int ndNo1, const int ndNo2, const T len, EX_IN brType) {
		set (id, ndNo1, ndNo2, brType);
		len_ = len;
	}

	//--------------------------------------------------------------------
	//put id,two nds and the len of the br
	void set (const int id, const int ndNo1, const int ndNo2, const T len) {
		set (id, ndNo1, ndNo2);
		len_ = len;
	}

	//--------------------------------------------------------------------
	//return the len of the br
	T getLen () {
		return len_;
	}

	//--------------------------------------------------------------------
	// return the sma nd
	int getSmaNd () {
		return smaNdNo_;
	}

	//--------------------------------------------------------------------
	// return the gre nd
	int getGreNd () {
		return greNdNo_;
	}

	//--------------------------------------------------------------------
	// return both the sma nd and gre one
	void getNd (int &smaNdNo, int &greNdNo) {
		smaNdNo = smaNdNo_;
		greNdNo = greNdNo_;
	}

	//return the tail node of this branches
	int getTailNd () {
		if (isStG_ == 1)
			return greNdNo_;
		else
			return smaNdNo_;
	}

	//return the head node of this branches
	int getHeadNd () {
		if (isStG_ == 1)
			return smaNdNo_;
		else
			return greNdNo_;
	}

	//--------------------------------------------------------------------
	//copy all data from br into this br
	void copy (Br<T> &br) {
		this->id_ = br.getId ();
		this->smaNdNo_ = br.getSmaNd ();
		this->greNdNo_ = br.getGreNd ();
		this->isEx_ = br.isEx ();
		this->len_ = br.getLen ();
		this->isStG_ = br.isStG ();
	}


	//--------------------------------------------------------------------
	//check whether or not brNo is an external br of this tree
	int isEx() {
		return isEx_;
	}

	//--------------------------------------------------------------------
	/*check whether or not brNo is smaNd===> greNd. it serves for
	tree in case of rooted tree
	*/
	int isStG() {
		return isStG_;
	}

	//--------------------------------------------------------------------
	//set the direction for this branch
	void setDir (BR_DIR dir) {
		if (dir == StG)
			isStG_ = 1;
		else
			isStG_ = 0;
	}

	//--------------------------------------------------------------------
	//check whether or not brNo is an internal br of this tree
	int isIn() {
		if (isEx_ == 1)
			return 0;
		else
			return 1;
	}

	//--------------------------------------------------------------------
	//overload = operation
	void operator = (Br<T> &br) {
		copy (br);
	}

	//--------------------------------------------------------------------
	//overload += operation
	void operator += (const T incLen) {
		len_ += incLen;
	}

	//--------------------------------------------------------------------
	//overload -= operation
	void operator -= (const T decLen) {
		len_ -= decLen;
	}


	/** print information */
	
	ostream &operator << (ostream &os) {
		os << "Branch " << smaNdNo_ << "-" << greNdNo_ << " length: " << len_ << endl;
		return os;
	}
	
	//get the remaning node of this branch
	int getRemNd (int existNdNo) {
		if (existNdNo != smaNdNo_)
			return smaNdNo_;
		else
			return greNdNo_;
	}

	//--------------------------------------------------------------------
	//release all memory of this class
void release () {}

	int isExNd (int ndNo) {
		int maxNExNd_ = alignment.getNSeq ();
		if (ndNo < maxNExNd_)
			return 1;
		else
			return 0;
	}

	int isInNd (int ndNo) {
		int maxNExNd_ = alignment.getNSeq ();
		if (ndNo >= maxNExNd_)
			return 1;
		else
			return 0;
	}

	//--------------------------------------------------------------------
	//destructor function of this class
	virtual ~Br () {
		release ();
		// std::cout << "this is the destructor of Br class " << endl;
	}

	int smaNeaExNdArr_[MAX_NUM_REP + 1];
	int smaNeaHeiArr_[MAX_NUM_REP + 1];

	int greNeaExNdArr_[MAX_NUM_REP + 1];
	int greNeaHeiArr_[MAX_NUM_REP + 1];

	int isSmaCmped_;
	int isGreCmped_;

	int smaBonus_;
	int greBonus_;
	/***********************************************************************
	***********************************************************************
	***********************************************************************
	***********************************************************************/
	/*two nodes of this branch, the number of smaNd_ is smaer than the number of greNd_*/
	int smaNdNo_;
	int greNdNo_;
	//the lenght of this branch
	T len_;

	//isStG = 1, it means that smalNd====>greNd,
	//isStG = 0, it means that greNd====>smaNd,
	int isStG_;

	
		
protected :


	//the identifical number of this branch, id in the array
	int id_;

	//check whether or not brNo is the external br of this tree
	int isEx_;

}
; //END CLASS BRANCH;
#endif
