/***************************************************************************
 *                                                                         *
 *   clutree.cpp    (begin: Apr 06 2004)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh}@cs.uni-duesseldorf.de                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "clutree.h"
#include "ali.h"

CluTree::CluTree () {
	isAct_ = 0;
}

CluTree::~CluTree () {}


void CluTree::set (int seqNo) {
	seqArr_.set (1, 0);
	seqArr_  += seqNo;
	alignment.getName (seqNo, tree_);
	isAct_ = 1;
}

void CluTree::set (Vec<int> &seqArr, Vec<char> &tree) {
	isAct_ = 1;
	seqArr_ = seqArr;
	tree_ = tree;
}

int CluTree::isSubClu (Vec<int> &seqMarkArr, int nCluSeq) {
	int nCurSeq_ = seqArr_.getSize ();
	if (nCurSeq_ >= nCluSeq)
		return 0;
	for (int count_ = 0; count_ < nCurSeq_; count_ ++)
		if (seqMarkArr[ seqArr_[count_] ] == 0)
			return 0;
	return 1;
}
