/***************************************************************************
 *                                                                         *
 *   exndarr.cpp    (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh}@cs.uni-duesseldorf.de                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <iostream>
#include "exnd.h"
#include "exndarr.h"
#include "ali.h"

using namespace std;

//construction function
ExNdArr::ExNdArr () {
	curNExNd_ = 0;
	maxNExNd_ = 0;
}

//--------------------------------------------------------------------
//construction function
ExNdArr::ExNdArr (const int maxNExNd) {
	curNExNd_ = 0;
	setLimit (maxNExNd);
}

//--------------------------------------------------------------------
//set limit of this array
void ExNdArr::setLimit (const int maxNExNd) {
	maxNExNd_ = maxNExNd;
	items_.set (maxNExNd_, maxNExNd_);
	ndNoLs_.setLimit (maxNExNd_);
}

//--------------------------------------------------------------------
//get the maximum number external node of this class
int ExNdArr::getMaxNNd () {
	return maxNExNd_;
}

//--------------------------------------------------------------------
//get the number of currently existing ex nodes
int ExNdArr::getCurNNd () {
	return curNExNd_;
}

//--------------------------------------------------------------------
//add a new node
void ExNdArr::operator += (ExNd &exNd) {
	int ndNo_ = exNd.getId ();
	items_[ndNo_] = exNd;
	curNExNd_++;
	ndNoLs_ += ndNo_;
}

//--------------------------------------------------------------------
//change the data in the ex node
void ExNdArr::changeItem (ExNd &exNd) {
	int ndNo_ = exNd.getId ();
	items_[ndNo_] =  exNd;
}

//--------------------------------------------------------------------
//clean the content of this array
void ExNdArr::clean () {
	for (int count_ = 0; count_ < maxNExNd_; count_ ++)
		items_[count_].clean ();
	curNExNd_ = 0;
	ndNoLs_.clean ();
}


//--------------------------------------------------------------------
//del an existing Ex node
void ExNdArr::operator -= (int exNdNo) {
	curNExNd_ --;
	items_[exNdNo].clean ();
	ndNoLs_.delItem (exNdNo);
}

//--------------------------------------------------------------------
//return ExNdArr[Exdex]
ExNd &ExNdArr::operator[] (const int index) {
	return items_[index];
}

//--------------------------------------------------------------------
//return the exNdNoLs
Vec<int> &ExNdArr::getNdNo () {
	return ndNoLs_;
}

//--------------------------------------------------------------------
//return the item array of this class
Vec<ExNd> &ExNdArr::getItem () {
	return items_;
}

//--------------------------------------------------------------------
//overload operator =
void ExNdArr::operator = (ExNdArr &exNdArr) {
	this->ndNoLs_ = exNdArr.getNdNo ();
	this->items_ = exNdArr.getItem ();
	this->maxNExNd_ = exNdArr.getMaxNNd ();
	this->curNExNd_ = exNdArr.getCurNNd ();
}

//check whether or not this this is an external node
int ExNdArr::isExNd (const int ndNo) {
	return (ndNo < maxNExNd_);
}

//--------------------------------------------------------------------
//release all memory of this class
void ExNdArr::release () {
	int realLimit_ = items_.getLimit ();
	items_.setSize (realLimit_);
	for (int count_ = 0; count_ < realLimit_; count_ ++)
		items_[count_].release ();
	items_.release ();
	ndNoLs_.release ();
}

//--------------------------------------------------------------------
//find the first positive external node no to be the outGrpNdNo
int ExNdArr::findOutGrpNd () {
	for (int count_ = 0; count_ < maxNExNd_; count_ ++)
		if (items_[count_].getId () != -1)
			return count_;
	return -1;
}

//--------------------------------------------------------------------
//destruction function
ExNdArr::~ExNdArr () {
	release ();
	//  std::cout << "this is the destructor of ExNdArr class " << endl;
}
