/***************************************************************************
 *                                                                         *
 *   exndarr.h      (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh}@cs.uni-duesseldorf.de                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef EXNDARR_H
#define EXNDARR_H

#include "vec.h"
#include "exnd.h"

//this class is a collect of all external nodes of the unrooted tree
class ExNdArr {
public :

	//construction function
	ExNdArr ();

	//construction function
	ExNdArr (const int maxNExNd);

	//set the limit of this array
	void setLimit (const int maxNExNd);

	//get the number of currently existing ex nds
	int getCurNNd ();

	//get the maximum number of external nodes of this array
	int getMaxNNd ();

	//return the identical exNd array
	Vec<int> &getNdNo ();

	//return the item array of this class
	Vec<ExNd> &getItem ();

	//clean the content of this array
	void clean ();

	//change the data in the ex nd
	void changeItem (ExNd &exNd);

	//find the first positive external node no to be the outGrpNdNo
	int findOutGrpNd ();


	//del an existing Ex nd
	void operator -= (int exNdNo);

	//add a new nd
	void operator += (ExNd &exNd);

	//return ExNdArr[Exdex]
	ExNd &operator[] (const int index);

	//this = ExNdArr
	void operator = (ExNdArr &ExNdArr);

	//check whether or not this this is an external node
	int isExNd (const int ndNo);

	//release all memmory for this class
	void release ();

	//destruction function
	~ExNdArr ();


	/****************************************************************
	****************************************************************
	****************************************************************
	****************************************************************/
private :
	//the number of currently existExg nds
	int curNExNd_;

	//the limit of this array
	int maxNExNd_;

	//array of Ex nds
	Vec<ExNd> items_;

	//the list of all current exnode in this array
	Vec<int> ndNoLs_;
}
; //end class ExNdArr
#endif
