/***************************************************************************
 *                                                                         *
 *   gtrm.h         (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh}@cs.uni-duesseldorf.de                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef  GRTM_H
#define GRTM_H

#include "basem.h"
/**
	General time reversible model
*/
class GTRM: public BaseM {
public :


	//cmp the base frequencies for this alignment
	//virtual void cmpBaseFrq ();

	/**
		all things are inited here
	*/
	virtual void init ();

	/**
		the target function which needs to be optimized
	*/
	virtual double targetFunk(double[]);
	
	
	/**
		the approximated derivative function
		@param x the input vector x
		@param dfx the derivative at x
		@return the function value at x
	*/
	//virtual double derivativeFunk(double x[], double dfx[]); 
	
	/**
		check of range of parameters
	*/
	//virtual bool checkRange(double x[]);

	/**
		check the propotion sum of variables to be <= 1.0
	*/
	//bool checkPropotionSum(double x[]);
	
	/**
		return TRUE if values is at the boundary
	*/
	//virtual bool atBoundary(double x[]);
	
	/**
		return TRUE if at the first stage of the parameter estimation
	*/
	//bool pamFirstStage();
	
	
	/**
		return the number of dimensions
	*/
	virtual int getNDim();
	
	/**
		pack the data to the vector x
	*/
	virtual void packData( double x[], double lower[], double upper[], bool bound_check[]);
	
	/**
		unpack data from vector x
	*/
	virtual void unpackData(double x[]);
	
	
	
	/**
		optimize the general time reversible parameters 
	*/
	virtual bool optPam ();


	/**
		Reinitialize
	*/
	void reInit ();
	
	/**
		compute the log likelihood when given a value
		this function is used to optimize the parameter of this model
	*/
	virtual double cmpNegLogLi (double value);


	/**
		create the rate parameters (not rate matrix)
	*/
	void createRateParameters ();


	/**
		release all memmory for this class
	*/
	void release ();

}
; //end of General model class
#endif
