/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef OPTPAIRSEQ_H
#define OPTPAIRSEQ_H

#include "seq.h"
#include "mat.h"
#include "brent.h"

typedef int PtnMat[NUM_CAN_STATE][NUM_CAN_STATE];


//using this class to optimize the distance between two sequences
class OptPairSeq : public Brent {
public :
	//the constructor function
	OptPairSeq ();

	//use this function for constructing this class
	void doConstructor ();

	//compute the gen distance between two sequences
	double cmp (Seq &seq1, Seq &seq2, double initGenDis = -1.0);

	//release all memmory for this class
	void release ();

	//the destructor function
	virtual ~OptPairSeq ();

	/********************************************************************
	********************************************************************
	********************************************************************
	********************************************************************
	********************************************************************/
	
	double opt_brent (double ax, double bx, double cx, double tol,
	                  double *foptx, double *f2optx, double fax, double fbx, double fcx, Seq* seq1, Seq* seq2, PtnMat &ptnMat);

	double optOneDim(double xmin, double xguess, double xmax,
	                 double tol, double *fx, double *f2x, Seq* seq1, Seq* seq2, PtnMat &ptnMat);
					 	
private :
	//the pointer to the two sequences which we want to optimize their distance
//	Seq *seq1_;
//	Seq *seq2_;

	//create the pair pattern matrix of two sequences
	void createPairPtn (Seq* seq1_, Seq* seq2_, PtnMat &ptnMat_);

	//ptnMat[baseNo1][baseNo1] = f, it means that (baseNo1, baseNo2) appears f times
//	int ptnMat_[NUM_CAN_STATE][NUM_CAN_STATE];

	//compute the observed distance between two sequences
	double cmpObsDis (Seq &seq1, Seq &seq2);

	//compute the negative log likelihood when the distance between them is brLen
	double cmpLogLiSpecificRate(double brLen, Seq* seq1_, Seq* seq2_);

	//compute the negative log likelihood when the distance between them is brLen
	double cmpLogLiGammaRate(double brLen, PtnMat& ptnMat_);

	//compute the negative log likelihood when the distance between them is time
	virtual double cmpNegLogLi(double time, Seq* seq1, Seq* seq2, PtnMat &ptnMat);

	
	
}
; // end of class

extern OptPairSeq opt_pairseq;

#endif
