/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/***************************************************************************
                          prediction.h  -  description
                             -------------------
    begin                : Fri Nov 28 2003
    copyright            : (C) 2003 by Le Sy Vinh & Arndt von Haeseler
    email                : vinh@cs.uni-duesseldorf.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PREDICTION_H
#define PREDICTION_H

#include "vec.h"
#include "mat.h"


class Prediction {
public :

	double predict (const char *fileName, double confidentVal, double & upperTime);

private :

	int nTime_;
	Vec<double> timeVec_;

	void cmpInvMat (Mat<double> &oriMat, Mat<double> &invMat, int size);

	void readMat (char *fileName, Mat<double> &oriMat, int &size);

	void multiple (Mat<double> &mat1, Mat<double> &mat2, Mat<double> &proMat);


	void multiple (Mat<double> &mat1, Vec<double> &vec2, Vec<double> &proVec);

	void multiple (Vec<double> &vec1, Mat<double> &mat2, Vec<double> &proVec);
	void multiple (Vec<double> &vec1, Vec<double> &vec2, Mat<double> &proMat);
	double multiple (Vec<double> &vec1, Vec<double> &vec2);

	/* THE FOLLOWING CODE COMES FROM tools.c in Yang's PAML package */
	//----------------------------------------------------------------------------------------
	double cmpLnGamma (double alpha);

	void readFile (const char *fileName);

	double cmpMuy (int k);

	void cmpLamdaMat (int k, Mat<double> &lamdaMat);

	void cmpVecA (int k, Vec<double> &aVec);

	double cmpExtinctTime (int k);
	double cmpUpperTime (int k, double alpha);
};

#endif
