/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PTNLS_H
#define PTNLS_H

#include "vec.h"
#include "ptn.h"

//this class contains all patterns of the alignment. Only the active sequences are taken into account
class PtnLs {
public:
	Vec<int> weightArr_;
	Vec<int> siteArr_;
	//int weightArr_[MAX_NUM_PTN];
	//int siteArr_[MAX_NUM_PTN];


	//the constructor
	PtnLs ();

	//use this function for constructing this class
	void doConstructor ();

	//get the number of sequences
	int getNSeq ();

	//get the number of sequences
	void setNSeq (const int nSeq);

	//everything will be inited here
	void init ();

	//clean all content of this pattern
	void clean ();

	/*
	create the order site list of all sites of this alignment
	such that Ptn (orderSiteNoLs[0]) < Ptn (orderSiteNoLs[1]) <...
	*/
	void createOrderSite (Vec<int> *orderSiteNoLs);


	// creat the pattern list
	void create ();


	//return items_[index]
	Ptn &getPtn (const int index);

	//return items_[index]
	Ptn *getPtnPoi (const int index);

	//get the number of patterns
	int getNPtn ();

	/**
		compute unconstrained log-likelihood
	*/
	double computeUnconstrainedLogL();

	inline char getBase (int ptnNo, int seqNo) {
		return items_[ptnNo].items_[seqNo];
	}

	//--------------------------------------------------------------------
	//write all information of this ptnls
	template <class Tout>
	Tout &write (Tout &out) {
		for (int ptnNo_ = 0; ptnNo_ < nPtn_; ptnNo_ ++)
			items_[ptnNo_].write (out);
		out << "=============end of this pattern list==========================" << endl;
		out << "this is a NEW WAY to create the PtnLs . . . " << endl;
		out << "the number different patterns is " << nPtn_ << endl;
		return out;
	}

	//--------------------------------------------------------------------
	inline int getWeight (int ptnNo) {
		return weightArr_[ptnNo];
	}


	//release all memmory for this class
	void release ();

	//the destructor
	virtual ~PtnLs ();

	/******************************************************************************************
	******************************************************************************************
	******************************************************************************************
	******************************************************************************************/
private:
	//the list of all patterns
	Vec<Ptn> items_;

	//the number of all patterns
	int nPtn_;

	//number of sequences
	int nSeq_;

}
; //end of class PtnLs

extern PtnLs ptnlist;

#endif // !defined(AFX_PATTERNLIST_H__0DE2B155_8E72_48D8_AA0E_CB07F7FE99BE__INCLUDED_)
