/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/***************************************************************************
                          rannum.cpp  -  description
                             -------------------
    begin                : Sun Jul 25 2004
    copyright            : (C) 2004 by 
    email                : vinh@cs.uni-duesseldorf.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "rannum.h"
#include "interface.h"

#ifdef WIN32
#include <sys/timeb.h>
#include <sys/types.h>
#include <winsock.h>
struct timezone {};
void gettimeofday(struct timeval* t,void* timezone)
{       struct _timeb timebuffer;
        _ftime( &timebuffer );
        t->tv_sec=timebuffer.time;
        t->tv_usec=1000*timebuffer.millitm;
}
#else
#include <sys/time.h>
#endif


long RanNum::idum;

//-------------------------------------------------------------
//creat an arbitary order node for quartet puzzle method
void RanNum::createOrderNd (int nSeq, Vec<int> &orderNdNoLs) {
	int count_;
	orderNdNoLs.set (nSeq, nSeq);
	for (count_ = 0; count_ < nSeq; count_ ++)
		orderNdNoLs[count_] = -1;

	for (int ndNo_ = 0; ndNo_ < nSeq; ndNo_ ++) {


		int pos_;
		if (major_step_test)
			pos_ = ndNo_; // for testing purpose
		else
			pos_ = RanNum::getRanInt (nSeq);

		for (count_ = 0; count_ < nSeq; count_ ++) {
			if (pos_ - count_ >= 0)
				if (orderNdNoLs[pos_ - count_] == -1) {
					orderNdNoLs[pos_ - count_] = ndNo_;
					break ;
				}//end if

			if (pos_ + count_ < nSeq)
				if (orderNdNoLs[pos_ + count_] == -1) {
					orderNdNoLs[pos_ + count_] = ndNo_;
					break ;
				}
		}//end for
	}
	if (!major_step_test)
		for (count_ = 0; count_ < nSeq * 2; count_ ++) {
			int posX_ = RanNum::getRanInt (nSeq);
			int posY_ = RanNum::getRanInt (nSeq);
			Utl::swap (orderNdNoLs[posX_], orderNdNoLs[posY_]);
		}
}/////////////////////////////////////////////////


/***********************************************************************************
***********************************************************************************
***********************************************************************************/
/*get a random number from x1 to x2 arcording to uniform distribution*/
int RanNum::getUniDis (int minVal, int maxVal) {
	int ranVal_ = RanNum::getRanInt (maxVal - minVal);

	return ranVal_ + minVal;
}

/******************************************************************************/
/* random numbers generator  (Numerical recipes)                              */
/******************************************************************************/
/* definitions */
#define IM1 2147483563
#define IM2 2147483399
#define AM (1.0/IM1)
#define IMM1 (IM1-1)
#define IA1 40014
#define IA2 40692
#define IQ1 53668
#define IQ2 52774
#define IR1 12211
#define IR2 3791
#define NTAB 32
#define NDIV (1+IMM1/NTAB)
#define EPS 1.2e-7
#define RNMX (1.0-EPS)

/******************************************************************************/
/* random numbers generator  (Numerical recipes)                              */
/******************************************************************************/

double RanNum::randomunitintervall()
/* Long period (> 2e18) random number generator. Returns a uniform random
   deviate between 0.0 and 1.0 (exclusive of endpoint values).
 
   Source:
   Press et al., "Numerical recipes in C", Cambridge University Press, 1992
   (chapter 7 "Random numbers", ran2 random number generator) */
{
	int j;
	long k;
	static long idum2=123456789;
	static long iy=0;
	static long iv[NTAB];
	double temp;

	if (idum <= 0) {
		if (-(idum) < 1)
			idum=1;
		else
			idum=-(idum);
		idum2=(idum);
		for (j=NTAB+7;j>=0;j--) {
			k=(idum)/IQ1;
			idum=IA1*(idum-k*IQ1)-k*IR1;
			if (idum < 0)
				idum += IM1;
			if (j < NTAB)
				iv[j] = idum;
		}
		iy=iv[0];
	}
	k=(idum)/IQ1;
	idum=IA1*(idum-k*IQ1)-k*IR1;
	if (idum < 0)
		idum += IM1;
	k=idum2/IQ2;
	idum2=IA2*(idum2-k*IQ2)-k*IR2;
	if (idum2 < 0)
		idum2 += IM2;
	j=iy/NDIV;
	iy=iv[j]-idum2;
	iv[j] = idum;
	if (iy < 1)
		iy += IMM1;
	if ((temp=AM*iy) > RNMX)
		return RNMX;
	else
		return temp;
} /* randomunitintervall */

/******************/
#undef IM1
#undef IM2
#undef AM
#undef IMM1
#undef IA1
#undef IA2
#undef IQ1
#undef IQ2
#undef IR1
#undef IR2
#undef NTAB
#undef NDIV
#undef EPS
#undef RNMX


int RanNum::initRandom(int seed) {
	struct timeval tv;
	struct timezone tz;
	// initialize random seed based on current time
	gettimeofday(&tv, &tz);
	//params.ran_seed = (unsigned) (tv.tv_sec+tv.tv_usec);
	srand((unsigned) (tv.tv_sec+tv.tv_usec));
	if (seed < 0)
		seed = rand();
	idum=-(long) seed;
#  ifdef PARALLEL
	{
		int n;
		for (n=0; n<mpi_myrank; n++)
			(void) randomunitintervall();
#       ifdef PVERBOSE1
		fprintf(stderr, "(%2d) !!! random seed set to %d, %dx drawn !!!\n", mpi_myrank, seed, n);
#       endif
	}
#  else
#       ifdef PVERBOSE1
	fprintf(stderr, "!!! random seed set to %d !!!\n", seed);
#       endif
#  endif
	return (seed);
}  /* initrandom */


/******************/


/* returns a random integer in the range [0; n - 1] */
int RanNum::getRanInt(int n) {
#  ifndef FIXEDINTRAND
#	ifndef PARALLEL
	int t;
	t = (int) floor(randomunitintervall()*n);
	return t;
#	else
	int m;
	for (m=1; m<mpi_size; m++)
		(void) randomunitintervall();
	p_randn+=(m-1); p_rand++;
	return (int) floor(randomunitintervall()*n);
#	endif
#  else
	fprintf(stderr, "!!! fixed \"random\" integers for testing purposes !!!\n");
	return (int)0;
#  endif /* FIXEDINTRAND */
} /* randominteger */

