/*
    SPDX-FileCopyrightText: 2008 Friedrich W. H. Kossebau <kossebau@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#include "testdocumentfileconnectjob.hpp"

// lib
#include "testdocumentfilesynchronizer.hpp"
#include "testdocumentfilewritethread.hpp"
#include "testdocument.hpp"
// Qt
#include <QCoreApplication>
// Std
#include <utility>

namespace Kasten {

TestDocumentFileConnectJob::TestDocumentFileConnectJob(std::unique_ptr<TestDocumentFileSynchronizer>&& synchronizer,
                                                       AbstractDocument* document,
                                                       const QUrl& url,
                                                       AbstractModelSynchronizer::ConnectOption option)
    : AbstractFileSystemConnectJob(std::move(synchronizer), document, url, option)
{
}

TestDocumentFileConnectJob::~TestDocumentFileConnectJob() = default;

void TestDocumentFileConnectJob::startConnectWithFile()
{
    auto* const testSynchronizer = qobject_cast<TestDocumentFileSynchronizer*>(synchronizer());
    auto* const testDocument = qobject_cast<TestDocument*>(document());
    auto writeThread = std::make_unique<TestDocumentFileWriteThread>(this, testSynchronizer->header(), testDocument, file());

    writeThread->start();
    while (!writeThread->wait(100)) {
        QCoreApplication::processEvents(QEventLoop::ExcludeUserInputEvents | QEventLoop::ExcludeSocketNotifiers);
    }

    const bool success = writeThread->success();

    if (success) {
        testSynchronizer->setDocument(testDocument);
    }
    writeThread.reset();

    complete(success);
}

}

#include "moc_testdocumentfileconnectjob.cpp"
