//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrordomain?language=objc)
    #[cfg(all(feature = "NSError", feature = "NSString"))]
    pub static NSURLErrorDomain: &'static NSErrorDomain;
}

extern "C" {
    /// The NSError userInfo dictionary key used to store and retrieve the URL which caused a load to fail.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorfailingurlerrorkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLErrorFailingURLErrorKey: &'static NSString;
}

extern "C" {
    /// The NSError userInfo dictionary key used to store and retrieve the NSString object for the URL which caused a load to fail.
    ///
    /// This constant supersedes NSErrorFailingURLStringKey, which was deprecated in Mac OS X 10.6.  Both constants refer to the same value for backward-compatibility, but this symbol name has a better prefix.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorfailingurlstringerrorkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLErrorFailingURLStringErrorKey: &'static NSString;
}

extern "C" {
    /// The NSError userInfo dictionary key used to store and retrieve the NSString object for the URL which caused a load to fail.
    ///
    /// This constant is deprecated in Mac OS X 10.6, and is superseded by NSURLErrorFailingURLStringErrorKey.  Both constants refer to the same value for backward-compatibility, but the new symbol name has a better prefix.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nserrorfailingurlstringkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSErrorFailingURLStringKey: &'static NSString;
}

extern "C" {
    /// The NSError userInfo dictionary key used to store and retrieve the SecTrustRef object representing the state of a failed SSL handshake.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorfailingurlpeertrusterrorkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLErrorFailingURLPeerTrustErrorKey: &'static NSString;
}

extern "C" {
    /// The NSError userInfo dictionary key used to store and retrieve the NSNumber corresponding to the reason why a background
    /// NSURLSessionTask was cancelled
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorbackgroundtaskcancelledreasonkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSURLErrorBackgroundTaskCancelledReasonKey: &'static NSString;
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorcancelledreasonuserforcequitapplication?language=objc)
pub const NSURLErrorCancelledReasonUserForceQuitApplication: NSInteger = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorcancelledreasonbackgroundupdatesdisabled?language=objc)
pub const NSURLErrorCancelledReasonBackgroundUpdatesDisabled: NSInteger = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorcancelledreasoninsufficientsystemresources?language=objc)
pub const NSURLErrorCancelledReasonInsufficientSystemResources: NSInteger = 2;

extern "C" {
    /// The NSErrorUserInfoKey used to store and retrieve the NSNumber object corresponding to the reason why the network is unavailable when the task failed due to unsatisfiable network constraints.  See the NSURLErrorNetworkUnavailableReason enum for details.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrornetworkunavailablereasonkey?language=objc)
    #[cfg(all(feature = "NSError", feature = "NSString"))]
    pub static NSURLErrorNetworkUnavailableReasonKey: &'static NSErrorUserInfoKey;
}

/// Constants used by NSError to indicate that a URLSessionTask failed because of unsatisfiable network constraints.
///
/// For example if the URLSessionConfiguration property allowsExpensiveNetworkAccess was set to NO and the only interfaces available were marked as expensive then the task would fail with a NSURLErrorNotConnectedToInternet error and the userInfo dictionary would contain the value NSURLErrorNetworkUnavailableReasonExpensive for the key NSURLErrorNetworkUnavailableReason.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrornetworkunavailablereason?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSURLErrorNetworkUnavailableReason(pub NSInteger);
impl NSURLErrorNetworkUnavailableReason {
    #[doc(alias = "NSURLErrorNetworkUnavailableReasonCellular")]
    pub const Cellular: Self = Self(0);
    #[doc(alias = "NSURLErrorNetworkUnavailableReasonExpensive")]
    pub const Expensive: Self = Self(1);
    #[doc(alias = "NSURLErrorNetworkUnavailableReasonConstrained")]
    pub const Constrained: Self = Self(2);
}

unsafe impl Encode for NSURLErrorNetworkUnavailableReason {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSURLErrorNetworkUnavailableReason {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorunknown?language=objc)
pub const NSURLErrorUnknown: NSInteger = -1;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorcancelled?language=objc)
pub const NSURLErrorCancelled: NSInteger = -999;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorbadurl?language=objc)
pub const NSURLErrorBadURL: NSInteger = -1000;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrortimedout?language=objc)
pub const NSURLErrorTimedOut: NSInteger = -1001;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorunsupportedurl?language=objc)
pub const NSURLErrorUnsupportedURL: NSInteger = -1002;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorcannotfindhost?language=objc)
pub const NSURLErrorCannotFindHost: NSInteger = -1003;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorcannotconnecttohost?language=objc)
pub const NSURLErrorCannotConnectToHost: NSInteger = -1004;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrornetworkconnectionlost?language=objc)
pub const NSURLErrorNetworkConnectionLost: NSInteger = -1005;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrordnslookupfailed?language=objc)
pub const NSURLErrorDNSLookupFailed: NSInteger = -1006;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorhttptoomanyredirects?language=objc)
pub const NSURLErrorHTTPTooManyRedirects: NSInteger = -1007;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorresourceunavailable?language=objc)
pub const NSURLErrorResourceUnavailable: NSInteger = -1008;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrornotconnectedtointernet?language=objc)
pub const NSURLErrorNotConnectedToInternet: NSInteger = -1009;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorredirecttononexistentlocation?language=objc)
pub const NSURLErrorRedirectToNonExistentLocation: NSInteger = -1010;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorbadserverresponse?language=objc)
pub const NSURLErrorBadServerResponse: NSInteger = -1011;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorusercancelledauthentication?language=objc)
pub const NSURLErrorUserCancelledAuthentication: NSInteger = -1012;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerroruserauthenticationrequired?language=objc)
pub const NSURLErrorUserAuthenticationRequired: NSInteger = -1013;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorzerobyteresource?language=objc)
pub const NSURLErrorZeroByteResource: NSInteger = -1014;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorcannotdecoderawdata?language=objc)
pub const NSURLErrorCannotDecodeRawData: NSInteger = -1015;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorcannotdecodecontentdata?language=objc)
pub const NSURLErrorCannotDecodeContentData: NSInteger = -1016;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorcannotparseresponse?language=objc)
pub const NSURLErrorCannotParseResponse: NSInteger = -1017;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorapptransportsecurityrequiressecureconnection?language=objc)
pub const NSURLErrorAppTransportSecurityRequiresSecureConnection: NSInteger = -1022;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorfiledoesnotexist?language=objc)
pub const NSURLErrorFileDoesNotExist: NSInteger = -1100;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorfileisdirectory?language=objc)
pub const NSURLErrorFileIsDirectory: NSInteger = -1101;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrornopermissionstoreadfile?language=objc)
pub const NSURLErrorNoPermissionsToReadFile: NSInteger = -1102;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrordatalengthexceedsmaximum?language=objc)
pub const NSURLErrorDataLengthExceedsMaximum: NSInteger = -1103;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorfileoutsidesafearea?language=objc)
pub const NSURLErrorFileOutsideSafeArea: NSInteger = -1104;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorsecureconnectionfailed?language=objc)
pub const NSURLErrorSecureConnectionFailed: NSInteger = -1200;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorservercertificatehasbaddate?language=objc)
pub const NSURLErrorServerCertificateHasBadDate: NSInteger = -1201;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorservercertificateuntrusted?language=objc)
pub const NSURLErrorServerCertificateUntrusted: NSInteger = -1202;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorservercertificatehasunknownroot?language=objc)
pub const NSURLErrorServerCertificateHasUnknownRoot: NSInteger = -1203;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorservercertificatenotyetvalid?language=objc)
pub const NSURLErrorServerCertificateNotYetValid: NSInteger = -1204;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorclientcertificaterejected?language=objc)
pub const NSURLErrorClientCertificateRejected: NSInteger = -1205;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorclientcertificaterequired?language=objc)
pub const NSURLErrorClientCertificateRequired: NSInteger = -1206;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorcannotloadfromnetwork?language=objc)
pub const NSURLErrorCannotLoadFromNetwork: NSInteger = -2000;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorcannotcreatefile?language=objc)
pub const NSURLErrorCannotCreateFile: NSInteger = -3000;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorcannotopenfile?language=objc)
pub const NSURLErrorCannotOpenFile: NSInteger = -3001;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorcannotclosefile?language=objc)
pub const NSURLErrorCannotCloseFile: NSInteger = -3002;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorcannotwritetofile?language=objc)
pub const NSURLErrorCannotWriteToFile: NSInteger = -3003;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorcannotremovefile?language=objc)
pub const NSURLErrorCannotRemoveFile: NSInteger = -3004;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorcannotmovefile?language=objc)
pub const NSURLErrorCannotMoveFile: NSInteger = -3005;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrordownloaddecodingfailedmidstream?language=objc)
pub const NSURLErrorDownloadDecodingFailedMidStream: NSInteger = -3006;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrordownloaddecodingfailedtocomplete?language=objc)
pub const NSURLErrorDownloadDecodingFailedToComplete: NSInteger = -3007;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorinternationalroamingoff?language=objc)
pub const NSURLErrorInternationalRoamingOff: NSInteger = -1018;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorcallisactive?language=objc)
pub const NSURLErrorCallIsActive: NSInteger = -1019;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrordatanotallowed?language=objc)
pub const NSURLErrorDataNotAllowed: NSInteger = -1020;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorrequestbodystreamexhausted?language=objc)
pub const NSURLErrorRequestBodyStreamExhausted: NSInteger = -1021;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorbackgroundsessionrequiressharedcontainer?language=objc)
pub const NSURLErrorBackgroundSessionRequiresSharedContainer: NSInteger = -995;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorbackgroundsessioninusebyanotherprocess?language=objc)
pub const NSURLErrorBackgroundSessionInUseByAnotherProcess: NSInteger = -996;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlerrorbackgroundsessionwasdisconnected?language=objc)
pub const NSURLErrorBackgroundSessionWasDisconnected: NSInteger = -997;
