package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExportVul invokes the aegis.ExportVul API synchronously
// api document: https://help.aliyun.com/api/aegis/exportvul.html
func (client *Client) ExportVul(request *ExportVulRequest) (response *ExportVulResponse, err error) {
	response = CreateExportVulResponse()
	err = client.DoAction(request, response)
	return
}

// ExportVulWithChan invokes the aegis.ExportVul API asynchronously
// api document: https://help.aliyun.com/api/aegis/exportvul.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExportVulWithChan(request *ExportVulRequest) (<-chan *ExportVulResponse, <-chan error) {
	responseChan := make(chan *ExportVulResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExportVul(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExportVulWithCallback invokes the aegis.ExportVul API asynchronously
// api document: https://help.aliyun.com/api/aegis/exportvul.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ExportVulWithCallback(request *ExportVulRequest, callback func(response *ExportVulResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExportVulResponse
		var err error
		defer close(result)
		response, err = client.ExportVul(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExportVulRequest is the request struct for api ExportVul
type ExportVulRequest struct {
	*requests.RpcRequest
	BatchName  string `position:"Query" name:"BatchName"`
	AliasName  string `position:"Query" name:"AliasName"`
	StatusList string `position:"Query" name:"StatusList"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	Level      string `position:"Query" name:"Level"`
	Resource   string `position:"Query" name:"Resource"`
	Name       string `position:"Query" name:"Name"`
	Dealed     string `position:"Query" name:"Dealed"`
	Lang       string `position:"Query" name:"Lang"`
	Type       string `position:"Query" name:"Type"`
	Necessity  string `position:"Query" name:"Necessity"`
	Uuids      string `position:"Query" name:"Uuids"`
}

// ExportVulResponse is the response struct for api ExportVul
type ExportVulResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Id           int    `json:"Id" xml:"Id"`
	FileName     string `json:"FileName" xml:"FileName"`
	CurrentCount int    `json:"CurrentCount" xml:"CurrentCount"`
	TotalCount   int    `json:"TotalCount" xml:"TotalCount"`
	Progress     int    `json:"Progress" xml:"Progress"`
	ExportStatus string `json:"ExportStatus" xml:"ExportStatus"`
	Message      string `json:"Message" xml:"Message"`
	Link         string `json:"Link" xml:"Link"`
}

// CreateExportVulRequest creates a request to invoke ExportVul API
func CreateExportVulRequest() (request *ExportVulRequest) {
	request = &ExportVulRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "ExportVul", "vipaegis", "openAPI")
	return
}

// CreateExportVulResponse creates a response to parse from ExportVul response
func CreateExportVulResponse() (response *ExportVulResponse) {
	response = &ExportVulResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
