package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGtmAvailableAlertGroup invokes the alidns.DescribeGtmAvailableAlertGroup API synchronously
func (client *Client) DescribeGtmAvailableAlertGroup(request *DescribeGtmAvailableAlertGroupRequest) (response *DescribeGtmAvailableAlertGroupResponse, err error) {
	response = CreateDescribeGtmAvailableAlertGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGtmAvailableAlertGroupWithChan invokes the alidns.DescribeGtmAvailableAlertGroup API asynchronously
func (client *Client) DescribeGtmAvailableAlertGroupWithChan(request *DescribeGtmAvailableAlertGroupRequest) (<-chan *DescribeGtmAvailableAlertGroupResponse, <-chan error) {
	responseChan := make(chan *DescribeGtmAvailableAlertGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGtmAvailableAlertGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGtmAvailableAlertGroupWithCallback invokes the alidns.DescribeGtmAvailableAlertGroup API asynchronously
func (client *Client) DescribeGtmAvailableAlertGroupWithCallback(request *DescribeGtmAvailableAlertGroupRequest, callback func(response *DescribeGtmAvailableAlertGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGtmAvailableAlertGroupResponse
		var err error
		defer close(result)
		response, err = client.DescribeGtmAvailableAlertGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGtmAvailableAlertGroupRequest is the request struct for api DescribeGtmAvailableAlertGroup
type DescribeGtmAvailableAlertGroupRequest struct {
	*requests.RpcRequest
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeGtmAvailableAlertGroupResponse is the response struct for api DescribeGtmAvailableAlertGroup
type DescribeGtmAvailableAlertGroupResponse struct {
	*responses.BaseResponse
	RequestId           string `json:"RequestId" xml:"RequestId"`
	AvailableAlertGroup string `json:"AvailableAlertGroup" xml:"AvailableAlertGroup"`
}

// CreateDescribeGtmAvailableAlertGroupRequest creates a request to invoke DescribeGtmAvailableAlertGroup API
func CreateDescribeGtmAvailableAlertGroupRequest() (request *DescribeGtmAvailableAlertGroupRequest) {
	request = &DescribeGtmAvailableAlertGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeGtmAvailableAlertGroup", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGtmAvailableAlertGroupResponse creates a response to parse from DescribeGtmAvailableAlertGroup response
func CreateDescribeGtmAvailableAlertGroupResponse() (response *DescribeGtmAvailableAlertGroupResponse) {
	response = &DescribeGtmAvailableAlertGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
