package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceDomains invokes the alidns.DescribeInstanceDomains API synchronously
func (client *Client) DescribeInstanceDomains(request *DescribeInstanceDomainsRequest) (response *DescribeInstanceDomainsResponse, err error) {
	response = CreateDescribeInstanceDomainsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceDomainsWithChan invokes the alidns.DescribeInstanceDomains API asynchronously
func (client *Client) DescribeInstanceDomainsWithChan(request *DescribeInstanceDomainsRequest) (<-chan *DescribeInstanceDomainsResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceDomainsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceDomains(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceDomainsWithCallback invokes the alidns.DescribeInstanceDomains API asynchronously
func (client *Client) DescribeInstanceDomainsWithCallback(request *DescribeInstanceDomainsRequest, callback func(response *DescribeInstanceDomainsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceDomainsResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceDomains(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceDomainsRequest is the request struct for api DescribeInstanceDomains
type DescribeInstanceDomainsRequest struct {
	*requests.RpcRequest
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
	UserClientIp string           `position:"Query" name:"UserClientIp"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	Lang         string           `position:"Query" name:"Lang"`
}

// DescribeInstanceDomainsResponse is the response struct for api DescribeInstanceDomains
type DescribeInstanceDomainsResponse struct {
	*responses.BaseResponse
	RequestId       string           `json:"RequestId" xml:"RequestId"`
	TotalItems      int              `json:"TotalItems" xml:"TotalItems"`
	PageNumber      int              `json:"PageNumber" xml:"PageNumber"`
	PageSize        int              `json:"PageSize" xml:"PageSize"`
	TotalPages      int              `json:"TotalPages" xml:"TotalPages"`
	InstanceDomains []InstanceDomain `json:"InstanceDomains" xml:"InstanceDomains"`
}

// CreateDescribeInstanceDomainsRequest creates a request to invoke DescribeInstanceDomains API
func CreateDescribeInstanceDomainsRequest() (request *DescribeInstanceDomainsRequest) {
	request = &DescribeInstanceDomainsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeInstanceDomains", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceDomainsResponse creates a response to parse from DescribeInstanceDomains response
func CreateDescribeInstanceDomainsResponse() (response *DescribeInstanceDomainsResponse) {
	response = &DescribeInstanceDomainsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
