package appmallsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TaobaoFilmGetSchedules invokes the appmallsservice.TaobaoFilmGetSchedules API synchronously
// api document: https://help.aliyun.com/api/appmallsservice/taobaofilmgetschedules.html
func (client *Client) TaobaoFilmGetSchedules(request *TaobaoFilmGetSchedulesRequest) (response *TaobaoFilmGetSchedulesResponse, err error) {
	response = CreateTaobaoFilmGetSchedulesResponse()
	err = client.DoAction(request, response)
	return
}

// TaobaoFilmGetSchedulesWithChan invokes the appmallsservice.TaobaoFilmGetSchedules API asynchronously
// api document: https://help.aliyun.com/api/appmallsservice/taobaofilmgetschedules.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TaobaoFilmGetSchedulesWithChan(request *TaobaoFilmGetSchedulesRequest) (<-chan *TaobaoFilmGetSchedulesResponse, <-chan error) {
	responseChan := make(chan *TaobaoFilmGetSchedulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TaobaoFilmGetSchedules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TaobaoFilmGetSchedulesWithCallback invokes the appmallsservice.TaobaoFilmGetSchedules API asynchronously
// api document: https://help.aliyun.com/api/appmallsservice/taobaofilmgetschedules.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TaobaoFilmGetSchedulesWithCallback(request *TaobaoFilmGetSchedulesRequest, callback func(response *TaobaoFilmGetSchedulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TaobaoFilmGetSchedulesResponse
		var err error
		defer close(result)
		response, err = client.TaobaoFilmGetSchedules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TaobaoFilmGetSchedulesRequest is the request struct for api TaobaoFilmGetSchedules
type TaobaoFilmGetSchedulesRequest struct {
	*requests.RpcRequest
	CinemaId   requests.Integer `position:"Query" name:"CinemaId"`
	ParamsJson string           `position:"Query" name:"ParamsJson"`
}

// TaobaoFilmGetSchedulesResponse is the response struct for api TaobaoFilmGetSchedules
type TaobaoFilmGetSchedulesResponse struct {
	*responses.BaseResponse
	ErrorCode string          `json:"ErrorCode" xml:"ErrorCode"`
	Msg       string          `json:"Msg" xml:"Msg"`
	SubCode   string          `json:"SubCode" xml:"SubCode"`
	SubMsg    string          `json:"SubMsg" xml:"SubMsg"`
	LogsId    string          `json:"LogsId" xml:"LogsId"`
	RequestId string          `json:"RequestId" xml:"RequestId"`
	Schedules []SchedulesItem `json:"Schedules" xml:"Schedules"`
}

// CreateTaobaoFilmGetSchedulesRequest creates a request to invoke TaobaoFilmGetSchedules API
func CreateTaobaoFilmGetSchedulesRequest() (request *TaobaoFilmGetSchedulesRequest) {
	request = &TaobaoFilmGetSchedulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("AppMallsService", "2018-02-24", "TaobaoFilmGetSchedules", "", "")
	return
}

// CreateTaobaoFilmGetSchedulesResponse creates a response to parse from TaobaoFilmGetSchedules response
func CreateTaobaoFilmGetSchedulesResponse() (response *TaobaoFilmGetSchedulesResponse) {
	response = &TaobaoFilmGetSchedulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
