package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchAlertHistories invokes the arms.SearchAlertHistories API synchronously
func (client *Client) SearchAlertHistories(request *SearchAlertHistoriesRequest) (response *SearchAlertHistoriesResponse, err error) {
	response = CreateSearchAlertHistoriesResponse()
	err = client.DoAction(request, response)
	return
}

// SearchAlertHistoriesWithChan invokes the arms.SearchAlertHistories API asynchronously
func (client *Client) SearchAlertHistoriesWithChan(request *SearchAlertHistoriesRequest) (<-chan *SearchAlertHistoriesResponse, <-chan error) {
	responseChan := make(chan *SearchAlertHistoriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchAlertHistories(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchAlertHistoriesWithCallback invokes the arms.SearchAlertHistories API asynchronously
func (client *Client) SearchAlertHistoriesWithCallback(request *SearchAlertHistoriesRequest, callback func(response *SearchAlertHistoriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchAlertHistoriesResponse
		var err error
		defer close(result)
		response, err = client.SearchAlertHistories(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchAlertHistoriesRequest is the request struct for api SearchAlertHistories
type SearchAlertHistoriesRequest struct {
	*requests.RpcRequest
	EndTime     requests.Integer `position:"Query" name:"EndTime"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	StartTime   requests.Integer `position:"Query" name:"StartTime"`
	ProxyUserId string           `position:"Query" name:"ProxyUserId"`
	AlertType   requests.Integer `position:"Query" name:"AlertType"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	AlertId     requests.Integer `position:"Query" name:"AlertId"`
}

// SearchAlertHistoriesResponse is the response struct for api SearchAlertHistories
type SearchAlertHistoriesResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	PageBean  PageBean `json:"PageBean" xml:"PageBean"`
}

// CreateSearchAlertHistoriesRequest creates a request to invoke SearchAlertHistories API
func CreateSearchAlertHistoriesRequest() (request *SearchAlertHistoriesRequest) {
	request = &SearchAlertHistoriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "SearchAlertHistories", "", "")
	request.Method = requests.POST
	return
}

// CreateSearchAlertHistoriesResponse creates a response to parse from SearchAlertHistories response
func CreateSearchAlertHistoriesResponse() (response *SearchAlertHistoriesResponse) {
	response = &SearchAlertHistoriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
