package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRealtimeSkillGroupStates invokes the ccc.ListRealtimeSkillGroupStates API synchronously
func (client *Client) ListRealtimeSkillGroupStates(request *ListRealtimeSkillGroupStatesRequest) (response *ListRealtimeSkillGroupStatesResponse, err error) {
	response = CreateListRealtimeSkillGroupStatesResponse()
	err = client.DoAction(request, response)
	return
}

// ListRealtimeSkillGroupStatesWithChan invokes the ccc.ListRealtimeSkillGroupStates API asynchronously
func (client *Client) ListRealtimeSkillGroupStatesWithChan(request *ListRealtimeSkillGroupStatesRequest) (<-chan *ListRealtimeSkillGroupStatesResponse, <-chan error) {
	responseChan := make(chan *ListRealtimeSkillGroupStatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRealtimeSkillGroupStates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRealtimeSkillGroupStatesWithCallback invokes the ccc.ListRealtimeSkillGroupStates API asynchronously
func (client *Client) ListRealtimeSkillGroupStatesWithCallback(request *ListRealtimeSkillGroupStatesRequest, callback func(response *ListRealtimeSkillGroupStatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRealtimeSkillGroupStatesResponse
		var err error
		defer close(result)
		response, err = client.ListRealtimeSkillGroupStates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRealtimeSkillGroupStatesRequest is the request struct for api ListRealtimeSkillGroupStates
type ListRealtimeSkillGroupStatesRequest struct {
	*requests.RpcRequest
	PageNumber       requests.Integer `position:"Query" name:"PageNumber"`
	SkillGroupIdList string           `position:"Body" name:"SkillGroupIdList"`
	InstanceId       string           `position:"Query" name:"InstanceId"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
}

// ListRealtimeSkillGroupStatesResponse is the response struct for api ListRealtimeSkillGroupStates
type ListRealtimeSkillGroupStatesResponse struct {
	*responses.BaseResponse
	Code           string                             `json:"Code" xml:"Code"`
	HttpStatusCode int                                `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                             `json:"Message" xml:"Message"`
	RequestId      string                             `json:"RequestId" xml:"RequestId"`
	Data           DataInListRealtimeSkillGroupStates `json:"Data" xml:"Data"`
}

// CreateListRealtimeSkillGroupStatesRequest creates a request to invoke ListRealtimeSkillGroupStates API
func CreateListRealtimeSkillGroupStatesRequest() (request *ListRealtimeSkillGroupStatesRequest) {
	request = &ListRealtimeSkillGroupStatesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ListRealtimeSkillGroupStates", "", "")
	request.Method = requests.POST
	return
}

// CreateListRealtimeSkillGroupStatesResponse creates a response to parse from ListRealtimeSkillGroupStates response
func CreateListRealtimeSkillGroupStatesResponse() (response *ListRealtimeSkillGroupStatesResponse) {
	response = &ListRealtimeSkillGroupStatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
