package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSpecificStagingConfig invokes the cdn.DeleteSpecificStagingConfig API synchronously
func (client *Client) DeleteSpecificStagingConfig(request *DeleteSpecificStagingConfigRequest) (response *DeleteSpecificStagingConfigResponse, err error) {
	response = CreateDeleteSpecificStagingConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSpecificStagingConfigWithChan invokes the cdn.DeleteSpecificStagingConfig API asynchronously
func (client *Client) DeleteSpecificStagingConfigWithChan(request *DeleteSpecificStagingConfigRequest) (<-chan *DeleteSpecificStagingConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteSpecificStagingConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSpecificStagingConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSpecificStagingConfigWithCallback invokes the cdn.DeleteSpecificStagingConfig API asynchronously
func (client *Client) DeleteSpecificStagingConfigWithCallback(request *DeleteSpecificStagingConfigRequest, callback func(response *DeleteSpecificStagingConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSpecificStagingConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteSpecificStagingConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSpecificStagingConfigRequest is the request struct for api DeleteSpecificStagingConfig
type DeleteSpecificStagingConfigRequest struct {
	*requests.RpcRequest
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	ConfigId      string           `position:"Query" name:"ConfigId"`
}

// DeleteSpecificStagingConfigResponse is the response struct for api DeleteSpecificStagingConfig
type DeleteSpecificStagingConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteSpecificStagingConfigRequest creates a request to invoke DeleteSpecificStagingConfig API
func CreateDeleteSpecificStagingConfigRequest() (request *DeleteSpecificStagingConfigRequest) {
	request = &DeleteSpecificStagingConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DeleteSpecificStagingConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteSpecificStagingConfigResponse creates a response to parse from DeleteSpecificStagingConfig response
func CreateDeleteSpecificStagingConfigResponse() (response *DeleteSpecificStagingConfigResponse) {
	response = &DeleteSpecificStagingConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
