package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEsExecuteData invokes the cdn.DescribeEsExecuteData API synchronously
func (client *Client) DescribeEsExecuteData(request *DescribeEsExecuteDataRequest) (response *DescribeEsExecuteDataResponse, err error) {
	response = CreateDescribeEsExecuteDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEsExecuteDataWithChan invokes the cdn.DescribeEsExecuteData API asynchronously
func (client *Client) DescribeEsExecuteDataWithChan(request *DescribeEsExecuteDataRequest) (<-chan *DescribeEsExecuteDataResponse, <-chan error) {
	responseChan := make(chan *DescribeEsExecuteDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEsExecuteData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEsExecuteDataWithCallback invokes the cdn.DescribeEsExecuteData API asynchronously
func (client *Client) DescribeEsExecuteDataWithCallback(request *DescribeEsExecuteDataRequest, callback func(response *DescribeEsExecuteDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEsExecuteDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeEsExecuteData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEsExecuteDataRequest is the request struct for api DescribeEsExecuteData
type DescribeEsExecuteDataRequest struct {
	*requests.RpcRequest
	StartTime string           `position:"Query" name:"StartTime"`
	EndTime   string           `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	RuleId    string           `position:"Query" name:"RuleId"`
}

// DescribeEsExecuteDataResponse is the response struct for api DescribeEsExecuteData
type DescribeEsExecuteDataResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Contents  []Content `json:"Contents" xml:"Contents"`
}

// CreateDescribeEsExecuteDataRequest creates a request to invoke DescribeEsExecuteData API
func CreateDescribeEsExecuteDataRequest() (request *DescribeEsExecuteDataRequest) {
	request = &DescribeEsExecuteDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeEsExecuteData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeEsExecuteDataResponse creates a response to parse from DescribeEsExecuteData response
func CreateDescribeEsExecuteDataResponse() (response *DescribeEsExecuteDataResponse) {
	response = &DescribeEsExecuteDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
