package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckVersionTransfer invokes the clickhouse.CheckVersionTransfer API synchronously
func (client *Client) CheckVersionTransfer(request *CheckVersionTransferRequest) (response *CheckVersionTransferResponse, err error) {
	response = CreateCheckVersionTransferResponse()
	err = client.DoAction(request, response)
	return
}

// CheckVersionTransferWithChan invokes the clickhouse.CheckVersionTransfer API asynchronously
func (client *Client) CheckVersionTransferWithChan(request *CheckVersionTransferRequest) (<-chan *CheckVersionTransferResponse, <-chan error) {
	responseChan := make(chan *CheckVersionTransferResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckVersionTransfer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckVersionTransferWithCallback invokes the clickhouse.CheckVersionTransfer API asynchronously
func (client *Client) CheckVersionTransferWithCallback(request *CheckVersionTransferRequest, callback func(response *CheckVersionTransferResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckVersionTransferResponse
		var err error
		defer close(result)
		response, err = client.CheckVersionTransfer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckVersionTransferRequest is the request struct for api CheckVersionTransfer
type CheckVersionTransferRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	SourceAccount        string           `position:"Query" name:"SourceAccount"`
	TargetAccount        string           `position:"Query" name:"TargetAccount"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	CheckAccount         requests.Boolean `position:"Query" name:"CheckAccount"`
	SourcePassword       string           `position:"Query" name:"SourcePassword"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	TargetPassword       string           `position:"Query" name:"TargetPassword"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TargetDbClusterId    string           `position:"Query" name:"TargetDbClusterId"`
}

// CheckVersionTransferResponse is the response struct for api CheckVersionTransfer
type CheckVersionTransferResponse struct {
	*responses.BaseResponse
	TotalCount      int         `json:"TotalCount" xml:"TotalCount"`
	CheckCategory   bool        `json:"CheckCategory" xml:"CheckCategory"`
	CheckConnection bool        `json:"CheckConnection" xml:"CheckConnection"`
	CheckStorage    bool        `json:"CheckStorage" xml:"CheckStorage"`
	RequestId       string      `json:"RequestId" xml:"RequestId"`
	TimeDuration    string      `json:"TimeDuration" xml:"TimeDuration"`
	CheckAccess     CheckAccess `json:"CheckAccess" xml:"CheckAccess"`
	CheckStatus     CheckStatus `json:"CheckStatus" xml:"CheckStatus"`
	CheckCode       CheckCode   `json:"CheckCode" xml:"CheckCode"`
}

// CreateCheckVersionTransferRequest creates a request to invoke CheckVersionTransfer API
func CreateCheckVersionTransferRequest() (request *CheckVersionTransferRequest) {
	request = &CheckVersionTransferRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "CheckVersionTransfer", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckVersionTransferResponse creates a response to parse from CheckVersionTransfer response
func CreateCheckVersionTransferResponse() (response *CheckVersionTransferResponse) {
	response = &CheckVersionTransferResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
