package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeColumns invokes the clickhouse.DescribeColumns API synchronously
func (client *Client) DescribeColumns(request *DescribeColumnsRequest) (response *DescribeColumnsResponse, err error) {
	response = CreateDescribeColumnsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeColumnsWithChan invokes the clickhouse.DescribeColumns API asynchronously
func (client *Client) DescribeColumnsWithChan(request *DescribeColumnsRequest) (<-chan *DescribeColumnsResponse, <-chan error) {
	responseChan := make(chan *DescribeColumnsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeColumns(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeColumnsWithCallback invokes the clickhouse.DescribeColumns API asynchronously
func (client *Client) DescribeColumnsWithCallback(request *DescribeColumnsRequest, callback func(response *DescribeColumnsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeColumnsResponse
		var err error
		defer close(result)
		response, err = client.DescribeColumns(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeColumnsRequest is the request struct for api DescribeColumns
type DescribeColumnsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TableName            string           `position:"Query" name:"TableName"`
	SchemaName           string           `position:"Query" name:"SchemaName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeColumnsResponse is the response struct for api DescribeColumns
type DescribeColumnsResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Items     ItemsInDescribeColumns `json:"Items" xml:"Items"`
}

// CreateDescribeColumnsRequest creates a request to invoke DescribeColumns API
func CreateDescribeColumnsRequest() (request *DescribeColumnsRequest) {
	request = &DescribeColumnsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "DescribeColumns", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeColumnsResponse creates a response to parse from DescribeColumns response
func CreateDescribeColumnsResponse() (response *DescribeColumnsResponse) {
	response = &DescribeColumnsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
