package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTransferHistory invokes the clickhouse.DescribeTransferHistory API synchronously
func (client *Client) DescribeTransferHistory(request *DescribeTransferHistoryRequest) (response *DescribeTransferHistoryResponse, err error) {
	response = CreateDescribeTransferHistoryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTransferHistoryWithChan invokes the clickhouse.DescribeTransferHistory API asynchronously
func (client *Client) DescribeTransferHistoryWithChan(request *DescribeTransferHistoryRequest) (<-chan *DescribeTransferHistoryResponse, <-chan error) {
	responseChan := make(chan *DescribeTransferHistoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTransferHistory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTransferHistoryWithCallback invokes the clickhouse.DescribeTransferHistory API asynchronously
func (client *Client) DescribeTransferHistoryWithCallback(request *DescribeTransferHistoryRequest, callback func(response *DescribeTransferHistoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTransferHistoryResponse
		var err error
		defer close(result)
		response, err = client.DescribeTransferHistory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTransferHistoryRequest is the request struct for api DescribeTransferHistory
type DescribeTransferHistoryRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeTransferHistoryResponse is the response struct for api DescribeTransferHistory
type DescribeTransferHistoryResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	HistoryDetails HistoryDetails `json:"HistoryDetails" xml:"HistoryDetails"`
}

// CreateDescribeTransferHistoryRequest creates a request to invoke DescribeTransferHistory API
func CreateDescribeTransferHistoryRequest() (request *DescribeTransferHistoryRequest) {
	request = &DescribeTransferHistoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "DescribeTransferHistory", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeTransferHistoryResponse creates a response to parse from DescribeTransferHistory response
func CreateDescribeTransferHistoryResponse() (response *DescribeTransferHistoryResponse) {
	response = &DescribeTransferHistoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
