package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReleaseClusterPublicConnection invokes the clickhouse.ReleaseClusterPublicConnection API synchronously
func (client *Client) ReleaseClusterPublicConnection(request *ReleaseClusterPublicConnectionRequest) (response *ReleaseClusterPublicConnectionResponse, err error) {
	response = CreateReleaseClusterPublicConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// ReleaseClusterPublicConnectionWithChan invokes the clickhouse.ReleaseClusterPublicConnection API asynchronously
func (client *Client) ReleaseClusterPublicConnectionWithChan(request *ReleaseClusterPublicConnectionRequest) (<-chan *ReleaseClusterPublicConnectionResponse, <-chan error) {
	responseChan := make(chan *ReleaseClusterPublicConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReleaseClusterPublicConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReleaseClusterPublicConnectionWithCallback invokes the clickhouse.ReleaseClusterPublicConnection API asynchronously
func (client *Client) ReleaseClusterPublicConnectionWithCallback(request *ReleaseClusterPublicConnectionRequest, callback func(response *ReleaseClusterPublicConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReleaseClusterPublicConnectionResponse
		var err error
		defer close(result)
		response, err = client.ReleaseClusterPublicConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReleaseClusterPublicConnectionRequest is the request struct for api ReleaseClusterPublicConnection
type ReleaseClusterPublicConnectionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ReleaseClusterPublicConnectionResponse is the response struct for api ReleaseClusterPublicConnection
type ReleaseClusterPublicConnectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateReleaseClusterPublicConnectionRequest creates a request to invoke ReleaseClusterPublicConnection API
func CreateReleaseClusterPublicConnectionRequest() (request *ReleaseClusterPublicConnectionRequest) {
	request = &ReleaseClusterPublicConnectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "ReleaseClusterPublicConnection", "", "")
	request.Method = requests.POST
	return
}

// CreateReleaseClusterPublicConnectionResponse creates a response to parse from ReleaseClusterPublicConnection response
func CreateReleaseClusterPublicConnectionResponse() (response *ReleaseClusterPublicConnectionResponse) {
	response = &ReleaseClusterPublicConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
