package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAXBBindRelation invokes the cloudcallcenter.CreateAXBBindRelation API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createaxbbindrelation.html
func (client *Client) CreateAXBBindRelation(request *CreateAXBBindRelationRequest) (response *CreateAXBBindRelationResponse, err error) {
	response = CreateCreateAXBBindRelationResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAXBBindRelationWithChan invokes the cloudcallcenter.CreateAXBBindRelation API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createaxbbindrelation.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateAXBBindRelationWithChan(request *CreateAXBBindRelationRequest) (<-chan *CreateAXBBindRelationResponse, <-chan error) {
	responseChan := make(chan *CreateAXBBindRelationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAXBBindRelation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAXBBindRelationWithCallback invokes the cloudcallcenter.CreateAXBBindRelation API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createaxbbindrelation.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateAXBBindRelationWithCallback(request *CreateAXBBindRelationRequest, callback func(response *CreateAXBBindRelationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAXBBindRelationResponse
		var err error
		defer close(result)
		response, err = client.CreateAXBBindRelation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAXBBindRelationRequest is the request struct for api CreateAXBBindRelation
type CreateAXBBindRelationRequest struct {
	*requests.RpcRequest
	PoolName    string `position:"Query" name:"PoolName"`
	ProviderId  string `position:"Query" name:"ProviderId"`
	Extra       string `position:"Query" name:"Extra"`
	BizId       string `position:"Query" name:"BizId"`
	PoolId      string `position:"Query" name:"PoolId"`
	PhoneNumber string `position:"Query" name:"PhoneNumber"`
	Type        string `position:"Query" name:"Type"`
}

// CreateAXBBindRelationResponse is the response struct for api CreateAXBBindRelation
type CreateAXBBindRelationResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateCreateAXBBindRelationRequest creates a request to invoke CreateAXBBindRelation API
func CreateCreateAXBBindRelationRequest() (request *CreateAXBBindRelationRequest) {
	request = &CreateAXBBindRelationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "CreateAXBBindRelation", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateAXBBindRelationResponse creates a response to parse from CreateAXBBindRelation response
func CreateCreateAXBBindRelationResponse() (response *CreateAXBBindRelationResponse) {
	response = &CreateAXBBindRelationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
