package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCategory invokes the cloudcallcenter.CreateCategory API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createcategory.html
func (client *Client) CreateCategory(request *CreateCategoryRequest) (response *CreateCategoryResponse, err error) {
	response = CreateCreateCategoryResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCategoryWithChan invokes the cloudcallcenter.CreateCategory API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createcategory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateCategoryWithChan(request *CreateCategoryRequest) (<-chan *CreateCategoryResponse, <-chan error) {
	responseChan := make(chan *CreateCategoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCategory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCategoryWithCallback invokes the cloudcallcenter.CreateCategory API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createcategory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateCategoryWithCallback(request *CreateCategoryRequest, callback func(response *CreateCategoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCategoryResponse
		var err error
		defer close(result)
		response, err = client.CreateCategory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCategoryRequest is the request struct for api CreateCategory
type CreateCategoryRequest struct {
	*requests.RpcRequest
	Type       requests.Integer `position:"Query" name:"Type"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	Name       string           `position:"Query" name:"Name"`
	Options    string           `position:"Query" name:"Options"`
	ScenarioId string           `position:"Query" name:"ScenarioId"`
}

// CreateCategoryResponse is the response struct for api CreateCategory
type CreateCategoryResponse struct {
	*responses.BaseResponse
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Success        bool     `json:"Success" xml:"Success"`
	Code           string   `json:"Code" xml:"Code"`
	Message        string   `json:"Message" xml:"Message"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Category       Category `json:"Category" xml:"Category"`
}

// CreateCreateCategoryRequest creates a request to invoke CreateCategory API
func CreateCreateCategoryRequest() (request *CreateCategoryRequest) {
	request = &CreateCategoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "CreateCategory", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateCategoryResponse creates a response to parse from CreateCategory response
func CreateCreateCategoryResponse() (response *CreateCategoryResponse) {
	response = &CreateCategoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
