package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeStores invokes the cloudesl.DescribeStores API synchronously
func (client *Client) DescribeStores(request *DescribeStoresRequest) (response *DescribeStoresResponse, err error) {
	response = CreateDescribeStoresResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeStoresWithChan invokes the cloudesl.DescribeStores API asynchronously
func (client *Client) DescribeStoresWithChan(request *DescribeStoresRequest) (<-chan *DescribeStoresResponse, <-chan error) {
	responseChan := make(chan *DescribeStoresResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeStores(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeStoresWithCallback invokes the cloudesl.DescribeStores API asynchronously
func (client *Client) DescribeStoresWithCallback(request *DescribeStoresRequest, callback func(response *DescribeStoresResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeStoresResponse
		var err error
		defer close(result)
		response, err = client.DescribeStores(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeStoresRequest is the request struct for api DescribeStores
type DescribeStoresRequest struct {
	*requests.RpcRequest
	ExtraParams     string           `position:"Body" name:"ExtraParams"`
	StoreName       string           `position:"Body" name:"StoreName"`
	StoreId         string           `position:"Body" name:"StoreId"`
	PageNumber      requests.Integer `position:"Body" name:"PageNumber"`
	FromDate        string           `position:"Body" name:"FromDate"`
	TemplateVersion string           `position:"Body" name:"TemplateVersion"`
	ToDate          string           `position:"Body" name:"ToDate"`
	PageSize        requests.Integer `position:"Body" name:"PageSize"`
	UserStoreCode   string           `position:"Body" name:"UserStoreCode"`
}

// DescribeStoresResponse is the response struct for api DescribeStores
type DescribeStoresResponse struct {
	*responses.BaseResponse
	ErrorMessage   string      `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode      string      `json:"ErrorCode" xml:"ErrorCode"`
	TotalCount     int         `json:"TotalCount" xml:"TotalCount"`
	Message        string      `json:"Message" xml:"Message"`
	PageSize       int         `json:"PageSize" xml:"PageSize"`
	DynamicCode    string      `json:"DynamicCode" xml:"DynamicCode"`
	Code           string      `json:"Code" xml:"Code"`
	PageNumber     int         `json:"PageNumber" xml:"PageNumber"`
	DynamicMessage string      `json:"DynamicMessage" xml:"DynamicMessage"`
	RequestId      string      `json:"RequestId" xml:"RequestId"`
	Success        bool        `json:"Success" xml:"Success"`
	Stores         []StoreInfo `json:"Stores" xml:"Stores"`
}

// CreateDescribeStoresRequest creates a request to invoke DescribeStores API
func CreateDescribeStoresRequest() (request *DescribeStoresRequest) {
	request = &DescribeStoresRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "DescribeStores", "cloudesl", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeStoresResponse creates a response to parse from DescribeStores response
func CreateDescribeStoresResponse() (response *DescribeStoresResponse) {
	response = &DescribeStoresResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
