package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetBid invokes the cloudwf.GetBid API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getbid.html
func (client *Client) GetBid(request *GetBidRequest) (response *GetBidResponse, err error) {
	response = CreateGetBidResponse()
	err = client.DoAction(request, response)
	return
}

// GetBidWithChan invokes the cloudwf.GetBid API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getbid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetBidWithChan(request *GetBidRequest) (<-chan *GetBidResponse, <-chan error) {
	responseChan := make(chan *GetBidResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetBid(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetBidWithCallback invokes the cloudwf.GetBid API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getbid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetBidWithCallback(request *GetBidRequest, callback func(response *GetBidResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetBidResponse
		var err error
		defer close(result)
		response, err = client.GetBid(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetBidRequest is the request struct for api GetBid
type GetBidRequest struct {
	*requests.RpcRequest
	Length    requests.Integer `position:"Query" name:"Length"`
	PageIndex requests.Integer `position:"Query" name:"PageIndex"`
}

// GetBidResponse is the response struct for api GetBid
type GetBidResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetBidRequest creates a request to invoke GetBid API
func CreateGetBidRequest() (request *GetBidRequest) {
	request = &GetBidRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetBid", "cloudwf", "openAPI")
	return
}

// CreateGetBidResponse creates a response to parse from GetBid response
func CreateGetBidResponse() (response *GetBidResponse) {
	response = &GetBidResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
