package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetScanProbeTimeSer invokes the cloudwf.GetScanProbeTimeSer API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getscanprobetimeser.html
func (client *Client) GetScanProbeTimeSer(request *GetScanProbeTimeSerRequest) (response *GetScanProbeTimeSerResponse, err error) {
	response = CreateGetScanProbeTimeSerResponse()
	err = client.DoAction(request, response)
	return
}

// GetScanProbeTimeSerWithChan invokes the cloudwf.GetScanProbeTimeSer API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getscanprobetimeser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetScanProbeTimeSerWithChan(request *GetScanProbeTimeSerRequest) (<-chan *GetScanProbeTimeSerResponse, <-chan error) {
	responseChan := make(chan *GetScanProbeTimeSerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetScanProbeTimeSer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetScanProbeTimeSerWithCallback invokes the cloudwf.GetScanProbeTimeSer API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getscanprobetimeser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetScanProbeTimeSerWithCallback(request *GetScanProbeTimeSerRequest, callback func(response *GetScanProbeTimeSerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetScanProbeTimeSerResponse
		var err error
		defer close(result)
		response, err = client.GetScanProbeTimeSer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetScanProbeTimeSerRequest is the request struct for api GetScanProbeTimeSer
type GetScanProbeTimeSerRequest struct {
	*requests.RpcRequest
	ZoomStart requests.Integer `position:"Query" name:"ZoomStart"`
	CompanyId requests.Integer `position:"Query" name:"CompanyId"`
	ApgroupId requests.Integer `position:"Query" name:"ApgroupId"`
	Start     requests.Integer `position:"Query" name:"Start"`
	ZoomEnd   requests.Integer `position:"Query" name:"ZoomEnd"`
	End       requests.Integer `position:"Query" name:"End"`
}

// GetScanProbeTimeSerResponse is the response struct for api GetScanProbeTimeSer
type GetScanProbeTimeSerResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetScanProbeTimeSerRequest creates a request to invoke GetScanProbeTimeSer API
func CreateGetScanProbeTimeSerRequest() (request *GetScanProbeTimeSerRequest) {
	request = &GetScanProbeTimeSerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetScanProbeTimeSer", "cloudwf", "openAPI")
	return
}

// CreateGetScanProbeTimeSerResponse creates a response to parse from GetScanProbeTimeSer response
func CreateGetScanProbeTimeSerResponse() (response *GetScanProbeTimeSerResponse) {
	response = &GetScanProbeTimeSerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
