package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUmengPagePermission4Root invokes the cloudwf.ListUmengPagePermission4Root API synchronously
// api document: https://help.aliyun.com/api/cloudwf/listumengpagepermission4root.html
func (client *Client) ListUmengPagePermission4Root(request *ListUmengPagePermission4RootRequest) (response *ListUmengPagePermission4RootResponse, err error) {
	response = CreateListUmengPagePermission4RootResponse()
	err = client.DoAction(request, response)
	return
}

// ListUmengPagePermission4RootWithChan invokes the cloudwf.ListUmengPagePermission4Root API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listumengpagepermission4root.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListUmengPagePermission4RootWithChan(request *ListUmengPagePermission4RootRequest) (<-chan *ListUmengPagePermission4RootResponse, <-chan error) {
	responseChan := make(chan *ListUmengPagePermission4RootResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUmengPagePermission4Root(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUmengPagePermission4RootWithCallback invokes the cloudwf.ListUmengPagePermission4Root API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listumengpagepermission4root.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListUmengPagePermission4RootWithCallback(request *ListUmengPagePermission4RootRequest, callback func(response *ListUmengPagePermission4RootResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUmengPagePermission4RootResponse
		var err error
		defer close(result)
		response, err = client.ListUmengPagePermission4Root(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUmengPagePermission4RootRequest is the request struct for api ListUmengPagePermission4Root
type ListUmengPagePermission4RootRequest struct {
	*requests.RpcRequest
	OrderCol    string           `position:"Query" name:"OrderCol"`
	Length      requests.Integer `position:"Query" name:"Length"`
	SearchEmail string           `position:"Query" name:"SearchEmail"`
	PageIndex   requests.Integer `position:"Query" name:"PageIndex"`
	OrderDir    string           `position:"Query" name:"OrderDir"`
}

// ListUmengPagePermission4RootResponse is the response struct for api ListUmengPagePermission4Root
type ListUmengPagePermission4RootResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateListUmengPagePermission4RootRequest creates a request to invoke ListUmengPagePermission4Root API
func CreateListUmengPagePermission4RootRequest() (request *ListUmengPagePermission4RootRequest) {
	request = &ListUmengPagePermission4RootRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ListUmengPagePermission4Root", "cloudwf", "openAPI")
	return
}

// CreateListUmengPagePermission4RootResponse creates a response to parse from ListUmengPagePermission4Root response
func CreateListUmengPagePermission4RootResponse() (response *ListUmengPagePermission4RootResponse) {
	response = &ListUmengPagePermission4RootResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
