package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OemFlowrateMonitor invokes the cloudwf.OemFlowrateMonitor API synchronously
// api document: https://help.aliyun.com/api/cloudwf/oemflowratemonitor.html
func (client *Client) OemFlowrateMonitor(request *OemFlowrateMonitorRequest) (response *OemFlowrateMonitorResponse, err error) {
	response = CreateOemFlowrateMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// OemFlowrateMonitorWithChan invokes the cloudwf.OemFlowrateMonitor API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/oemflowratemonitor.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OemFlowrateMonitorWithChan(request *OemFlowrateMonitorRequest) (<-chan *OemFlowrateMonitorResponse, <-chan error) {
	responseChan := make(chan *OemFlowrateMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OemFlowrateMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OemFlowrateMonitorWithCallback invokes the cloudwf.OemFlowrateMonitor API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/oemflowratemonitor.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OemFlowrateMonitorWithCallback(request *OemFlowrateMonitorRequest, callback func(response *OemFlowrateMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OemFlowrateMonitorResponse
		var err error
		defer close(result)
		response, err = client.OemFlowrateMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OemFlowrateMonitorRequest is the request struct for api OemFlowrateMonitor
type OemFlowrateMonitorRequest struct {
	*requests.RpcRequest
	Gsid requests.Integer `position:"Query" name:"Gsid"`
}

// OemFlowrateMonitorResponse is the response struct for api OemFlowrateMonitor
type OemFlowrateMonitorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateOemFlowrateMonitorRequest creates a request to invoke OemFlowrateMonitor API
func CreateOemFlowrateMonitorRequest() (request *OemFlowrateMonitorRequest) {
	request = &OemFlowrateMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "OemFlowrateMonitor", "cloudwf", "openAPI")
	return
}

// CreateOemFlowrateMonitorResponse creates a response to parse from OemFlowrateMonitor response
func CreateOemFlowrateMonitorResponse() (response *OemFlowrateMonitorResponse) {
	response = &OemFlowrateMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
