package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OemHeatMap invokes the cloudwf.OemHeatMap API synchronously
// api document: https://help.aliyun.com/api/cloudwf/oemheatmap.html
func (client *Client) OemHeatMap(request *OemHeatMapRequest) (response *OemHeatMapResponse, err error) {
	response = CreateOemHeatMapResponse()
	err = client.DoAction(request, response)
	return
}

// OemHeatMapWithChan invokes the cloudwf.OemHeatMap API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/oemheatmap.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OemHeatMapWithChan(request *OemHeatMapRequest) (<-chan *OemHeatMapResponse, <-chan error) {
	responseChan := make(chan *OemHeatMapResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OemHeatMap(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OemHeatMapWithCallback invokes the cloudwf.OemHeatMap API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/oemheatmap.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OemHeatMapWithCallback(request *OemHeatMapRequest, callback func(response *OemHeatMapResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OemHeatMapResponse
		var err error
		defer close(result)
		response, err = client.OemHeatMap(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OemHeatMapRequest is the request struct for api OemHeatMap
type OemHeatMapRequest struct {
	*requests.RpcRequest
	Gsid requests.Integer `position:"Query" name:"Gsid"`
}

// OemHeatMapResponse is the response struct for api OemHeatMap
type OemHeatMapResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateOemHeatMapRequest creates a request to invoke OemHeatMap API
func CreateOemHeatMapRequest() (request *OemHeatMapRequest) {
	request = &OemHeatMapRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "OemHeatMap", "cloudwf", "openAPI")
	return
}

// CreateOemHeatMapResponse creates a response to parse from OemHeatMap response
func CreateOemHeatMapResponse() (response *OemHeatMapResponse) {
	response = &OemHeatMapResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
