package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MergeMergeRequest invokes the codeup.MergeMergeRequest API synchronously
func (client *Client) MergeMergeRequest(request *MergeMergeRequestRequest) (response *MergeMergeRequestResponse, err error) {
	response = CreateMergeMergeRequestResponse()
	err = client.DoAction(request, response)
	return
}

// MergeMergeRequestWithChan invokes the codeup.MergeMergeRequest API asynchronously
func (client *Client) MergeMergeRequestWithChan(request *MergeMergeRequestRequest) (<-chan *MergeMergeRequestResponse, <-chan error) {
	responseChan := make(chan *MergeMergeRequestResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MergeMergeRequest(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MergeMergeRequestWithCallback invokes the codeup.MergeMergeRequest API asynchronously
func (client *Client) MergeMergeRequestWithCallback(request *MergeMergeRequestRequest, callback func(response *MergeMergeRequestResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MergeMergeRequestResponse
		var err error
		defer close(result)
		response, err = client.MergeMergeRequest(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MergeMergeRequestRequest is the request struct for api MergeMergeRequest
type MergeMergeRequestRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	SubUserId      string           `position:"Query" name:"SubUserId"`
	MergeRequestId requests.Integer `position:"Path" name:"MergeRequestId"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
}

// MergeMergeRequestResponse is the response struct for api MergeMergeRequest
type MergeMergeRequestResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateMergeMergeRequestRequest creates a request to invoke MergeMergeRequest API
func CreateMergeMergeRequestRequest() (request *MergeMergeRequestRequest) {
	request = &MergeMergeRequestRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "MergeMergeRequest", "/api/v3/projects/[ProjectId]/merge_request/[MergeRequestId]/merge", "", "")
	request.Method = requests.PUT
	return
}

// CreateMergeMergeRequestResponse creates a response to parse from MergeMergeRequest response
func CreateMergeMergeRequestResponse() (response *MergeMergeRequestResponse) {
	response = &MergeMergeRequestResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
