package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAggregateCompliancePack invokes the config.CreateAggregateCompliancePack API synchronously
func (client *Client) CreateAggregateCompliancePack(request *CreateAggregateCompliancePackRequest) (response *CreateAggregateCompliancePackResponse, err error) {
	response = CreateCreateAggregateCompliancePackResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAggregateCompliancePackWithChan invokes the config.CreateAggregateCompliancePack API asynchronously
func (client *Client) CreateAggregateCompliancePackWithChan(request *CreateAggregateCompliancePackRequest) (<-chan *CreateAggregateCompliancePackResponse, <-chan error) {
	responseChan := make(chan *CreateAggregateCompliancePackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAggregateCompliancePack(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAggregateCompliancePackWithCallback invokes the config.CreateAggregateCompliancePack API asynchronously
func (client *Client) CreateAggregateCompliancePackWithCallback(request *CreateAggregateCompliancePackRequest, callback func(response *CreateAggregateCompliancePackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAggregateCompliancePackResponse
		var err error
		defer close(result)
		response, err = client.CreateAggregateCompliancePack(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAggregateCompliancePackRequest is the request struct for api CreateAggregateCompliancePack
type CreateAggregateCompliancePackRequest struct {
	*requests.RpcRequest
	CompliancePackName       string                                      `position:"Body" name:"CompliancePackName"`
	ClientToken              string                                      `position:"Body" name:"ClientToken"`
	CompliancePackTemplateId string                                      `position:"Body" name:"CompliancePackTemplateId"`
	Description              string                                      `position:"Body" name:"Description"`
	AggregatorId             string                                      `position:"Body" name:"AggregatorId"`
	ConfigRules              *[]CreateAggregateCompliancePackConfigRules `position:"Body" name:"ConfigRules"  type:"Json"`
	RiskLevel                requests.Integer                            `position:"Body" name:"RiskLevel"`
}

// CreateAggregateCompliancePackConfigRules is a repeated param struct in CreateAggregateCompliancePackRequest
type CreateAggregateCompliancePackConfigRules struct {
	ManagedRuleIdentifier string                                                              `name:"ManagedRuleIdentifier"`
	ConfigRuleParameters  *[]CreateAggregateCompliancePackConfigRulesConfigRuleParametersItem `name:"ConfigRuleParameters" type:"Repeated"`
	ConfigRuleId          string                                                              `name:"ConfigRuleId"`
	ConfigRuleName        string                                                              `name:"ConfigRuleName"`
	Description           string                                                              `name:"Description"`
	RiskLevel             string                                                              `name:"RiskLevel"`
}

// CreateAggregateCompliancePackConfigRulesConfigRuleParametersItem is a repeated param struct in CreateAggregateCompliancePackRequest
type CreateAggregateCompliancePackConfigRulesConfigRuleParametersItem struct {
	ParameterValue string `name:"ParameterValue"`
	ParameterName  string `name:"ParameterName"`
}

// CreateAggregateCompliancePackResponse is the response struct for api CreateAggregateCompliancePack
type CreateAggregateCompliancePackResponse struct {
	*responses.BaseResponse
	CompliancePackId string `json:"CompliancePackId" xml:"CompliancePackId"`
	RequestId        string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateAggregateCompliancePackRequest creates a request to invoke CreateAggregateCompliancePack API
func CreateCreateAggregateCompliancePackRequest() (request *CreateAggregateCompliancePackRequest) {
	request = &CreateAggregateCompliancePackRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "CreateAggregateCompliancePack", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateAggregateCompliancePackResponse creates a response to parse from CreateAggregateCompliancePack response
func CreateCreateAggregateCompliancePackResponse() (response *CreateAggregateCompliancePackResponse) {
	response = &CreateAggregateCompliancePackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
