package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDiscoveredResourceCountsGroupByResourceType invokes the config.GetDiscoveredResourceCountsGroupByResourceType API synchronously
func (client *Client) GetDiscoveredResourceCountsGroupByResourceType(request *GetDiscoveredResourceCountsGroupByResourceTypeRequest) (response *GetDiscoveredResourceCountsGroupByResourceTypeResponse, err error) {
	response = CreateGetDiscoveredResourceCountsGroupByResourceTypeResponse()
	err = client.DoAction(request, response)
	return
}

// GetDiscoveredResourceCountsGroupByResourceTypeWithChan invokes the config.GetDiscoveredResourceCountsGroupByResourceType API asynchronously
func (client *Client) GetDiscoveredResourceCountsGroupByResourceTypeWithChan(request *GetDiscoveredResourceCountsGroupByResourceTypeRequest) (<-chan *GetDiscoveredResourceCountsGroupByResourceTypeResponse, <-chan error) {
	responseChan := make(chan *GetDiscoveredResourceCountsGroupByResourceTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDiscoveredResourceCountsGroupByResourceType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDiscoveredResourceCountsGroupByResourceTypeWithCallback invokes the config.GetDiscoveredResourceCountsGroupByResourceType API asynchronously
func (client *Client) GetDiscoveredResourceCountsGroupByResourceTypeWithCallback(request *GetDiscoveredResourceCountsGroupByResourceTypeRequest, callback func(response *GetDiscoveredResourceCountsGroupByResourceTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDiscoveredResourceCountsGroupByResourceTypeResponse
		var err error
		defer close(result)
		response, err = client.GetDiscoveredResourceCountsGroupByResourceType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDiscoveredResourceCountsGroupByResourceTypeRequest is the request struct for api GetDiscoveredResourceCountsGroupByResourceType
type GetDiscoveredResourceCountsGroupByResourceTypeRequest struct {
	*requests.RpcRequest
	Region string `position:"Query" name:"Region"`
}

// GetDiscoveredResourceCountsGroupByResourceTypeResponse is the response struct for api GetDiscoveredResourceCountsGroupByResourceType
type GetDiscoveredResourceCountsGroupByResourceTypeResponse struct {
	*responses.BaseResponse
	RequestId                       string                 `json:"RequestId" xml:"RequestId"`
	DiscoveredResourceCountsSummary []GroupedResourceCount `json:"DiscoveredResourceCountsSummary" xml:"DiscoveredResourceCountsSummary"`
}

// CreateGetDiscoveredResourceCountsGroupByResourceTypeRequest creates a request to invoke GetDiscoveredResourceCountsGroupByResourceType API
func CreateGetDiscoveredResourceCountsGroupByResourceTypeRequest() (request *GetDiscoveredResourceCountsGroupByResourceTypeRequest) {
	request = &GetDiscoveredResourceCountsGroupByResourceTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetDiscoveredResourceCountsGroupByResourceType", "", "")
	request.Method = requests.GET
	return
}

// CreateGetDiscoveredResourceCountsGroupByResourceTypeResponse creates a response to parse from GetDiscoveredResourceCountsGroupByResourceType response
func CreateGetDiscoveredResourceCountsGroupByResourceTypeResponse() (response *GetDiscoveredResourceCountsGroupByResourceTypeResponse) {
	response = &GetDiscoveredResourceCountsGroupByResourceTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
