package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTableLevel invokes the dataworks_public.ListTableLevel API synchronously
func (client *Client) ListTableLevel(request *ListTableLevelRequest) (response *ListTableLevelResponse, err error) {
	response = CreateListTableLevelResponse()
	err = client.DoAction(request, response)
	return
}

// ListTableLevelWithChan invokes the dataworks_public.ListTableLevel API asynchronously
func (client *Client) ListTableLevelWithChan(request *ListTableLevelRequest) (<-chan *ListTableLevelResponse, <-chan error) {
	responseChan := make(chan *ListTableLevelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTableLevel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTableLevelWithCallback invokes the dataworks_public.ListTableLevel API asynchronously
func (client *Client) ListTableLevelWithCallback(request *ListTableLevelRequest, callback func(response *ListTableLevelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTableLevelResponse
		var err error
		defer close(result)
		response, err = client.ListTableLevel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTableLevelRequest is the request struct for api ListTableLevel
type ListTableLevelRequest struct {
	*requests.RpcRequest
	LevelType requests.Integer `position:"Query" name:"LevelType"`
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	PageNum   requests.Integer `position:"Query" name:"PageNum"`
	ProjectId requests.Integer `position:"Query" name:"ProjectId"`
}

// ListTableLevelResponse is the response struct for api ListTableLevel
type ListTableLevelResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	ErrorCode      string         `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string         `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int            `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Success        bool           `json:"Success" xml:"Success"`
	TableLevelInfo TableLevelInfo `json:"TableLevelInfo" xml:"TableLevelInfo"`
}

// CreateListTableLevelRequest creates a request to invoke ListTableLevel API
func CreateListTableLevelRequest() (request *ListTableLevelRequest) {
	request = &ListTableLevelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListTableLevel", "", "")
	request.Method = requests.GET
	return
}

// CreateListTableLevelResponse creates a response to parse from ListTableLevel response
func CreateListTableLevelResponse() (response *ListTableLevelResponse) {
	response = &ListTableLevelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
