package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigLayer7Rule invokes the ddoscoo.ConfigLayer7Rule API synchronously
func (client *Client) ConfigLayer7Rule(request *ConfigLayer7RuleRequest) (response *ConfigLayer7RuleResponse, err error) {
	response = CreateConfigLayer7RuleResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigLayer7RuleWithChan invokes the ddoscoo.ConfigLayer7Rule API asynchronously
func (client *Client) ConfigLayer7RuleWithChan(request *ConfigLayer7RuleRequest) (<-chan *ConfigLayer7RuleResponse, <-chan error) {
	responseChan := make(chan *ConfigLayer7RuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigLayer7Rule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigLayer7RuleWithCallback invokes the ddoscoo.ConfigLayer7Rule API asynchronously
func (client *Client) ConfigLayer7RuleWithCallback(request *ConfigLayer7RuleRequest, callback func(response *ConfigLayer7RuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigLayer7RuleResponse
		var err error
		defer close(result)
		response, err = client.ConfigLayer7Rule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigLayer7RuleRequest is the request struct for api ConfigLayer7Rule
type ConfigLayer7RuleRequest struct {
	*requests.RpcRequest
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	ProxyTypeList   string           `position:"Query" name:"ProxyTypeList"`
	RsType          requests.Integer `position:"Query" name:"RsType"`
	RealServers     *[]string        `position:"Query" name:"RealServers"  type:"Repeated"`
	ProxyTypes      *[]string        `position:"Query" name:"ProxyTypes"  type:"Repeated"`
	InstanceIds     *[]string        `position:"Query" name:"InstanceIds"  type:"Repeated"`
	Domain          string           `position:"Query" name:"Domain"`
}

// ConfigLayer7RuleResponse is the response struct for api ConfigLayer7Rule
type ConfigLayer7RuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateConfigLayer7RuleRequest creates a request to invoke ConfigLayer7Rule API
func CreateConfigLayer7RuleRequest() (request *ConfigLayer7RuleRequest) {
	request = &ConfigLayer7RuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "ConfigLayer7Rule", "", "")
	request.Method = requests.POST
	return
}

// CreateConfigLayer7RuleResponse creates a response to parse from ConfigLayer7Rule response
func CreateConfigLayer7RuleResponse() (response *ConfigLayer7RuleResponse) {
	response = &ConfigLayer7RuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
