package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLayer4RuleAttributes invokes the ddoscoo.DescribeLayer4RuleAttributes API synchronously
func (client *Client) DescribeLayer4RuleAttributes(request *DescribeLayer4RuleAttributesRequest) (response *DescribeLayer4RuleAttributesResponse, err error) {
	response = CreateDescribeLayer4RuleAttributesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLayer4RuleAttributesWithChan invokes the ddoscoo.DescribeLayer4RuleAttributes API asynchronously
func (client *Client) DescribeLayer4RuleAttributesWithChan(request *DescribeLayer4RuleAttributesRequest) (<-chan *DescribeLayer4RuleAttributesResponse, <-chan error) {
	responseChan := make(chan *DescribeLayer4RuleAttributesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLayer4RuleAttributes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLayer4RuleAttributesWithCallback invokes the ddoscoo.DescribeLayer4RuleAttributes API asynchronously
func (client *Client) DescribeLayer4RuleAttributesWithCallback(request *DescribeLayer4RuleAttributesRequest, callback func(response *DescribeLayer4RuleAttributesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLayer4RuleAttributesResponse
		var err error
		defer close(result)
		response, err = client.DescribeLayer4RuleAttributes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLayer4RuleAttributesRequest is the request struct for api DescribeLayer4RuleAttributes
type DescribeLayer4RuleAttributesRequest struct {
	*requests.RpcRequest
	Listeners string `position:"Query" name:"Listeners"`
	SourceIp  string `position:"Query" name:"SourceIp"`
}

// DescribeLayer4RuleAttributesResponse is the response struct for api DescribeLayer4RuleAttributes
type DescribeLayer4RuleAttributesResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Listeners []Listener `json:"Listeners" xml:"Listeners"`
}

// CreateDescribeLayer4RuleAttributesRequest creates a request to invoke DescribeLayer4RuleAttributes API
func CreateDescribeLayer4RuleAttributesRequest() (request *DescribeLayer4RuleAttributesRequest) {
	request = &DescribeLayer4RuleAttributesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "DescribeLayer4RuleAttributes", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeLayer4RuleAttributesResponse creates a response to parse from DescribeLayer4RuleAttributes response
func CreateDescribeLayer4RuleAttributesResponse() (response *DescribeLayer4RuleAttributesResponse) {
	response = &DescribeLayer4RuleAttributesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
